/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.factory;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.util.Properties;
import javax.sql.DataSource;
import online.sanen.cdm.basic.Driven;
import online.sanen.cdm.basic.Obstract;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;

public class DataSourceFactory {
    public static DataSource create(Obstract obstract) throws Exception {
        switch (obstract.getDataSouseType()) {
            case Druid: {
                DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)DataSourceFactory.createProperties(obstract));
                druidDataSource.setTestOnBorrow(false);
                druidDataSource.setRemoveAbandoned(false);
                druidDataSource.setMaxWait(5000L);
                if (obstract.getDriver().equals(Driven.ORACLE.getValue())) {
                    druidDataSource.setValidationQuery("SELECT 1 FROM DUAL");
                } else {
                    druidDataSource.setValidationQuery("SELECT 1");
                }
                return druidDataSource;
            }
        }
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)DataSourceFactory.createProperties(obstract));
        if (obstract.getDriver().equals(Driven.ORACLE.getValue())) {
            dataSource.setValidationQuery("SELECT 1 FROM DUAL");
        } else {
            dataSource.setValidationQuery("SELECT 1");
        }
        return dataSource;
    }

    private static Properties createProperties(final Obstract obstract) {
        return new Properties(){
            private static final long serialVersionUID = 1L;
            {
                this.setProperty("driverClassName", obstract.getDriver());
                this.setProperty("url", obstract.getUrl());
                this.setProperty("username", obstract.getUsername());
                this.setProperty("password", obstract.getPassword());
                this.setProperty("validationQuery", "select 1");
            }
        };
    }
}

