/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.BootstrapDevice;
import online.sanen.cdm.basic.Obstract;
import online.sanen.cdm.factory.DataSourceFactory;
import online.sanen.cdm.template.JdbcTemplate;
import online.sanen.cdm.template.transaction.Transaction;

public class BootStrapFactoty {
    static Map<Object, Bootstrap> cache = new HashMap<Object, Bootstrap>();
    static Map<Bootstrap, Transaction> transactions = new HashMap<Bootstrap, Transaction>();

    public static boolean contains(Object key) {
        return cache.containsKey(key);
    }

    public static Bootstrap get(Object key) {
        return cache.get(key);
    }

    public static Bootstrap put(Object bootStrapId, Bootstrap bootstrap) {
        cache.put(bootStrapId, bootstrap);
        return bootstrap;
    }

    public static Bootstrap remove(String bootstrapId) {
        return cache.remove(bootstrapId);
    }

    public static void removeByPrefix(String prefix) {
        ArrayList array = new ArrayList();
        cache.keySet().forEach(item -> {
            if (item.toString().startsWith(prefix)) {
                array.add(item.toString());
            }
        });
        array.forEach(cache::remove);
    }

    public static Bootstrap load(Consumer<Obstract> consumer) throws Exception {
        Obstract obstract = new Obstract();
        consumer.accept(obstract);
        return new BootstrapDevice(new JdbcTemplate(DataSourceFactory.create(obstract)), obstract.isShowSql(), obstract.isCache(), obstract.isLog());
    }

    public static Bootstrap load(Object bootStrapId, Consumer<Obstract> consumer) throws Exception {
        if (cache.containsKey(bootStrapId)) {
            return cache.get(bootStrapId);
        }
        Bootstrap bootstrap = BootStrapFactoty.load(consumer);
        BootStrapFactoty.put(bootStrapId, bootstrap);
        return bootstrap;
    }

    public static boolean isUniqueness() {
        return cache.size() == 1;
    }

    public static Bootstrap getFirst() {
        Optional findFirst = cache.keySet().stream().findFirst();
        return findFirst.isPresent() ? cache.get(findFirst.get()) : null;
    }

    public static void registedTransaction(Bootstrap bootstrap, Transaction transaction) {
        transactions.put(bootstrap, transaction);
    }
}

