/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import online.sanen.cdm.basic.CdmSupportsException;
import online.sanen.cdm.basic.ProductType;

public interface SqlConversion
extends Function<String, String> {
    public static final List<String> list1 = Arrays.asList("CHAR", "CHARACTER", "STRING", "BOOLEAN", "TIMESTAMP", "ORACLECLOB", "DATE", "VARCHAR", "VARCHAR2", "CLOB");
    public static final List<String> list2 = Arrays.asList("SHORT", "INTEGER", "LONG", "INT", "BIGDECIMAL", "NUMBER");
    public static final List<String> list3 = Arrays.asList("FLOAT", "DOUBLE");
    public static final List<String> list4 = Arrays.asList("BYTE");

    @Override
    default public String apply(String sb) {
        switch (this.applyProductType()) {
            case SQLITE: {
                for (String it : list1) {
                    sb = sb.replace("${" + it + "}", "text ");
                }
                for (String it : list2) {
                    sb = sb.replace("${" + it + "}", "integer");
                }
                for (String it : list3) {
                    sb = sb.replace("${" + it + "}", "real");
                }
                for (String it : list4) {
                    sb = sb.replace("${" + it + "}", "blob");
                }
                sb = sb.replace("${PRIMARY}", " primary key autoincrement");
                break;
            }
            case MYSQL: {
                for (String it : list1) {
                    sb = sb.replace("${" + it + "}", "text ");
                }
                for (String it : list2) {
                    sb = sb.replace("${" + it + "}", "integer");
                }
                for (String it : list3) {
                    sb = sb.replace("${" + it + "}", "real");
                }
                for (String it : list4) {
                    sb = sb.replace("${" + it + "}", "blob");
                }
                if (!sb.contains("${PRIMARY}")) break;
                sb = sb.replace("${PRIMARY}", "NOT NULL AUTO_INCREMENT");
                sb = sb + ",PRIMARY KEY ( " + this.applyPrimaryKey() + " )";
                break;
            }
            case MICROSOFT_SQL_SERVER: {
                for (String it : list1) {
                    sb = sb.replace("${" + it + "}", "text ");
                }
                for (String it : list2) {
                    sb = sb.replace("${" + it + "}", "integer");
                }
                for (String it : list3) {
                    sb = sb.replace("${" + it + "}", "real");
                }
                for (String it : list4) {
                    sb = sb.replace("${" + it + "}", "Binary");
                }
                sb = sb.replace("${PRIMARY}", "primary key not null");
                break;
            }
            case ORACLE: {
                for (String it : list1) {
                    sb = sb.replace("${" + it + "}", "clob ");
                }
                for (String it : list2) {
                    sb = sb.replace("${" + it + "}", "integer");
                }
                for (String it : list3) {
                    sb = sb.replace("${" + it + "}", "real");
                }
                for (String it : list4) {
                    sb = sb.replace("${" + it + "}", "Binary");
                }
                sb = sb.replace("${PRIMARY}", "primary key not null");
                break;
            }
            default: {
                throw new CdmSupportsException(this.applyProductType());
            }
        }
        return sb;
    }

    default public String applyPrimaryKey() {
        return null;
    }

    public ProductType applyProductType();
}

