/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.QueryUP;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;

public class QueryUPDevice
implements QueryUP {
    Structure structure;

    public QueryUPDevice(Structure structure) {
        this.structure = structure;
    }

    public QueryUP setTableName(String tableName) {
        this.structure.setTableName(tableName);
        return this;
    }

    public QueryUP setFields(String ... fields) {
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryUP addCondition(String fieldName, Condition.Conditions conditions) {
        try {
            this.structure.addCondition(Condition.builder((String)fieldName, (Condition.Conditions)conditions));
        }
        catch (CdmConditionException e) {
            e.printStackTrace();
        }
        return this;
    }

    public QueryUP addCondition(String fieldName, Condition.Conditions conditions, Object value) {
        this.structure.addCondition(Condition.builder((String)fieldName, (Condition.Conditions)conditions, (Object)value));
        return this;
    }

    public QueryUP addCondition(Consumer<List<Condition>> consumer) {
        consumer.accept(this.structure.getConditions());
        return this;
    }

    public QueryUP setExceptFields(String ... fields) {
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public int update() {
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

