/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.QueryTB;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.DataField;
import online.sanen.cdm.basic.ProductType;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Sorts;
import online.sanen.cdm.basic.StreamConsumer;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;
import online.sanen.cdm.template.JdbcTemplate;

public class QueryTBDevice
implements QueryTB {
    Structure structure;

    public QueryTBDevice(Manager manager, String tableName) {
        this.structure = new Structure(manager);
        this.structure.setTableName(tableName);
    }

    public QueryTB addEntry(Class<? extends BasicBean> entry) {
        this.structure.setEntry_class(entry);
        return this;
    }

    public QueryTB addCondition(String fieldName, Condition.Conditions conditions) {
        try {
            this.structure.addCondition(Condition.builder((String)fieldName, (Condition.Conditions)conditions));
        }
        catch (CdmConditionException e) {
            e.printStackTrace();
        }
        return this;
    }

    public QueryTB addCondition(String fieldName, Condition.Conditions conditions, Object value) {
        this.structure.addCondition(Condition.builder((String)fieldName, (Condition.Conditions)conditions, (Object)value));
        return this;
    }

    public QueryTB addCondition(Consumer<List<Condition>> consumer) {
        consumer.accept(this.structure.getConditions());
        return this;
    }

    public QueryTB sort(final Sorts sorts, final String ... fields) {
        this.structure.setSortSupport(new Structure.SortSupport(){

            public String toString() {
                StringBuilder sb = new StringBuilder(" order by ");
                for (String field : fields) {
                    sb.append(field + ",");
                }
                sb.setLength(sb.length() - 1);
                sb.append(" " + sorts.getValue());
                return sb.toString();
            }
        });
        return this;
    }

    public QueryTB setFields(String ... fields) {
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryTB setExceptFields(String ... fields) {
        this.structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public <T> T unique() {
        return (T)Assembler.create(QueryType.select, ResultType.Object, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public <T> List<T> list() {
        return (List)Assembler.create(QueryType.select, ResultType.List, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer, final Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, aliases));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Function<List<DataField>, Object> consumer, final StreamConsumer datas, final Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, datas, aliases));
                return pipeline;
            }
        });
    }

    public List<Map<String, Object>> maps() {
        return (List)Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete() {
        return (Integer)Assembler.create(QueryType.delete, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public QueryTB limit(Integer ... args) {
        this.structure.setLimit(args);
        this.structure.setHasLimitAble(true);
        return this;
    }

    public boolean isExsites() {
        try {
            JdbcTemplate template = this.structure.getTemplate();
            template.queryForRowSet("SELECT 1 FROM " + this.structure.getTableName(), new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int updateName(String newName) {
        this.structure.setSql(ProductType.updateTableNameSQL((ProductType)this.structure.productType(), (String)this.structure.getTableName(), (String)newName));
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int clear() {
        return this.delete();
    }

    public int drop() {
        return (Integer)Assembler.create(QueryType.drop, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int addColumn(String columnName, String type) {
        this.structure.setSql("ALTER TABLE " + this.structure.getTableName() + " ADD COLUMN  " + columnName + " " + type);
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public String createAndInsert(final String newTableName) {
        return (String)Assembler.create(QueryType.select, ResultType.String, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.limitHandel());
                pipeline.addLast(HandelFactory.createAndInsert(newTableName));
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

