/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.QuerySQL;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.DataField;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.StreamConsumer;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;
import online.sanen.cdm.resource.R;

public class QuerySQLDevice
implements QuerySQL {
    Structure structure;

    public QuerySQLDevice(Manager manager, String sql, Object ... paramers) {
        this.structure = new Structure(manager);
        this.structure.setSql(sql);
        this.structure.setCls(this.getClass());
        this.addParamers(paramers);
    }

    public QuerySQL addParamer(int index, Object paramer) {
        if (index < 1) {
            try {
                throw new CdmConditionException(R.strings.Exception_Parametric_Anomaly);
            }
            catch (CdmConditionException e) {
                e.printStackTrace();
            }
        }
        if (paramer == null) {
            try {
                throw new CdmConditionException(R.strings.Exception_Parametric_Null);
            }
            catch (CdmConditionException e) {
                e.printStackTrace();
            }
        }
        this.structure.addParamer(index, paramer);
        return this;
    }

    public QuerySQL addEntry(Class<? extends BasicBean> entry) {
        if (entry == null) {
            try {
                throw new CdmConditionException(R.strings.Exception_EntryClass_Null);
            }
            catch (CdmConditionException e) {
                e.printStackTrace();
            }
        }
        this.structure.setEntry_class(entry);
        return this;
    }

    public int update() {
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public List<?> list() {
        return (List)Assembler.create(QueryType.select, ResultType.List, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public List<Map<String, Object>> maps() {
        return (List)Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Consumer<List<Map<String, Object>>> consumer, Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, null));
                return pipeline;
            }
        });
    }

    public void stream(final int bufferSize, final Function<List<DataField>, Object> consumer, final StreamConsumer datas, final Map<String, String> aliases) {
        Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(bufferSize, consumer, datas, aliases));
                return pipeline;
            }
        });
    }

    public List<Map<String, Object>> stream(final int count) {
        return (List)Assembler.create(QueryType.select, ResultType.Maps, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.streamHandel(count));
                return pipeline;
            }
        });
    }

    public Map<String, Object> map() {
        return (Map)Assembler.create(QueryType.select, ResultType.Map, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public Object unique() {
        return Assembler.create(QueryType.select, ResultType.Object, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    private void addParamers(Object[] paramers) {
        if (paramers != null) {
            for (int i = 0; i < paramers.length; ++i) {
                this.addParamer(i + 1, paramers[i]);
            }
        }
    }

    public List<DataField> getQueryColumns() {
        return (List)Assembler.create(QueryType.select, ResultType.DataField, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.resultColumnsHandel());
                return pipeline;
            }
        });
    }
}

