/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.analyse.Validate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.QueryMap;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;

public class QueryMapDevice
implements QueryMap {
    Structure structure;

    public QueryMapDevice(Manager manager, String tableName, Map<String, Object> entry) {
        this.structure = new Structure(manager);
        this.structure.setTableName(tableName);
        this.structure.setEnMap(entry);
    }

    public QueryMapDevice(Manager manager, String tableName, Collection<Map<String, Object>> maps) {
        this.structure = new Structure(manager);
        this.structure.setTableName(tableName);
        this.structure.setEnMaps(maps);
    }

    public int insert() {
        if (this.structure.getEnMaps() != null) {
            return this.batchUpdate(QueryType.insert);
        }
        return (Integer)Assembler.create(QueryType.insert, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete() {
        if (this.structure.getPrimaryKey() == null) {
            throw new NullPointerException("Primary key is null,Use the setPrimaryKey(String primary) method to set this ");
        }
        if (this.structure.getEnMaps() != null) {
            return this.batchUpdate(QueryType.delete);
        }
        return (Integer)Assembler.create(QueryType.delete, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int create() {
        return (Integer)Assembler.create(QueryType.create, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int update() {
        if (this.structure.getPrimaryKey() == null) {
            throw new NullPointerException("Primary key is null,Use the setPrimaryKey(String primary) method to set this ");
        }
        if (this.structure.getEnMaps() != null) {
            return this.batchUpdate(QueryType.update);
        }
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    private int batchUpdate(QueryType type) {
        return (Integer)Assembler.create(type, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.batchUpdate());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete(String primary) {
        this.setPrimary(primary);
        return this.delete();
    }

    public int updateBy(String primary) {
        this.setPrimary(primary);
        return this.update();
    }

    public QueryMap setFields(String ... fields) {
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryMap setExceptFields(String ... fields) {
        this.structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryMap setPrimary(String primary) {
        if (Validate.isNullOrEmpty((Object)primary)) {
            throw new NullPointerException("Primary key is null.");
        }
        Object value = this.structure.getEnMap().get(primary);
        this.structure.setPrimaryKey(primary);
        this.structure.setPrimaryValue(value);
        return this;
    }
}

