/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import online.sanen.cdm.Assembler;
import online.sanen.cdm.QueryEN;
import online.sanen.cdm.QueryUP;
import online.sanen.cdm.QueryUPDevice;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;

public class QueryENDevice
implements QueryEN {
    Structure structure;

    public QueryENDevice(Manager manager, BasicBean entry) {
        this.structure = new Structure(manager);
        this.structure.setEntry(entry);
    }

    public QueryENDevice(Manager manager, Collection<BasicBean> entrys) {
        this.structure = new Structure(manager);
        this.structure.setEntrys(entrys);
    }

    public QueryEN setTableName(String tableName) {
        this.structure.setTableName(tableName);
        return this;
    }

    public QueryEN setFields(String ... fields) {
        this.structure.setFields(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public QueryEN setExceptFields(String ... fields) {
        this.structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
        return this;
    }

    public int insert() {
        if (this.structure.getEntrys() != null) {
            return this.batchUpdate(QueryType.insert);
        }
        return (Integer)Assembler.create(QueryType.insert, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int delete() {
        if (this.structure.getEntrys() != null) {
            return this.batchUpdate(QueryType.delete);
        }
        return (Integer)Assembler.create(QueryType.delete, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public int update() {
        if (this.structure.getEntrys() != null) {
            return this.batchUpdate(QueryType.update);
        }
        return (Integer)Assembler.create(QueryType.update, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.paramerHandel());
                pipeline.addLast(HandelFactory.primaryKeyHandel());
                pipeline.addLast(HandelFactory.conditionHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    private int batchUpdate(QueryType type) {
        return (Integer)Assembler.create(type, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.commonFieldHandel());
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.batchUpdate());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }

    public QueryUP addCondition(String fieldName, Condition.Conditions conditions) {
        try {
            this.structure.addCondition(Condition.builder((String)fieldName, (Condition.Conditions)conditions));
        }
        catch (CdmConditionException e) {
            e.printStackTrace();
        }
        return new QueryUPDevice(this.structure);
    }

    public QueryUP addCondition(String fieldName, Condition.Conditions conditions, Object value) {
        this.structure.addCondition(Condition.builder((String)fieldName, (Condition.Conditions)conditions, (Object)value));
        return new QueryUPDevice(this.structure);
    }

    public QueryUP addCondition(Consumer<List<Condition>> consumer) {
        consumer.accept(this.structure.getConditions());
        return new QueryUPDevice(this.structure);
    }

    public int create() {
        return (Integer)Assembler.create(QueryType.create, ResultType.Int, this.structure, new PipelineFactory(){

            public Pipeline getPipeline() {
                PipelineDivice pipeline = new PipelineDivice();
                pipeline.addLast(HandelFactory.sqlHandel());
                pipeline.addLast(HandelFactory.resultHandel());
                pipeline.addLast(HandelFactory.debugHandel());
                return pipeline;
            }
        });
    }
}

