/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.analyse.Template;
import com.mhdt.analyse.Validate;
import java.util.Collection;
import java.util.Map;
import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.DataInformation;
import online.sanen.cdm.ManagerDevice;
import online.sanen.cdm.QueryEN;
import online.sanen.cdm.QueryENDevice;
import online.sanen.cdm.QueryMap;
import online.sanen.cdm.QueryMapDevice;
import online.sanen.cdm.QueryPK;
import online.sanen.cdm.QueryPKDevice;
import online.sanen.cdm.QuerySQL;
import online.sanen.cdm.QuerySQLDevice;
import online.sanen.cdm.QueryTB;
import online.sanen.cdm.QueryTBDevice;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Cdm;
import online.sanen.cdm.basic.CdmSupportsException;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.infomation.MSInfomation;
import online.sanen.cdm.infomation.MySQLInfomation;
import online.sanen.cdm.infomation.OracleInfomation;
import online.sanen.cdm.infomation.SQLiteInfomation;
import online.sanen.cdm.template.JdbcTemplate;
import online.sanen.cdm.template.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapDevice
implements Bootstrap {
    final Logger logger = LoggerFactory.getLogger(Bootstrap.class);
    Manager manager = new ManagerDevice();
    boolean isLog;
    JdbcTemplate template;
    boolean isSqlFormat;
    boolean isShowSql;
    boolean isCache;
    DataInformation dataInformation;

    public BootstrapDevice(JdbcTemplate jdbcTemplate) throws Exception {
        this(jdbcTemplate, true);
    }

    public BootstrapDevice(JdbcTemplate jdbcTemplate, boolean isShowSql) throws Exception {
        this(jdbcTemplate, isShowSql, false, false);
    }

    public BootstrapDevice(JdbcTemplate jdbctemplate, boolean isShowSql, boolean isCache, boolean isLog) throws Exception {
        this.setIsShowSql(isShowSql);
        this.setIsCache(isCache);
        this.setIsLog(isLog);
        this.setTemplate(jdbctemplate);
        if (isLog) {
            System.err.println(this.manager);
        }
    }

    public boolean isLog() {
        return this.isLog;
    }

    public void setIsLog(boolean isLog) {
        this.isLog = isLog;
    }

    public void setTemplate(JdbcTemplate template) throws Exception {
        this.manager.setTemplate(template);
        if (this.isLog()) {
            Template tem = new Template(BootstrapDevice.class.getResourceAsStream("info.template"));
            tem.setParamer("dataBase", this.manager.productType().toString());
            tem.setParamer("url", this.manager.getUrl());
            this.logger.info(tem.getText());
        }
    }

    public void setIsSqlFormat(boolean isSqlFormat) {
        this.manager.setSqlFormat(isSqlFormat);
    }

    public void setIsShowSql(Boolean isShowSql) {
        this.manager.setIsShowSql(isShowSql.booleanValue());
    }

    public void setIsCache(Boolean isCache) {
        this.manager.setIsCache(isCache.booleanValue());
    }

    public QuerySQL createSQL(String sql, Object ... paramers) {
        if (Validate.isNullOrEmpty((Object)sql)) {
            throw new NullPointerException("Sql is null");
        }
        return new QuerySQLDevice(this.manager, sql, paramers);
    }

    public QuerySQL createSQL(String sql) {
        if (Validate.isNullOrEmpty((Object)sql)) {
            throw new NullPointerException("Sql is null");
        }
        return new QuerySQLDevice(this.manager, sql, new Object[0]);
    }

    public QueryEN query(BasicBean entry) {
        if (entry == null) {
            throw new NullPointerException("Entry is null");
        }
        if (this.manager == null) {
            throw new NullPointerException("manager is null");
        }
        return new QueryENDevice(this.manager, entry);
    }

    public QueryTB query(String tableName) {
        if (Validate.isNullOrEmpty((Object)tableName)) {
            throw new NullPointerException("Table is null");
        }
        return new QueryTBDevice(this.manager, tableName);
    }

    public <T extends BasicBean> QueryPK<T> query(Class<T> entryCls, Object primarykey) {
        if (entryCls == null) {
            throw new NullPointerException("Entry class is null");
        }
        if (primarykey == null) {
            throw new NullPointerException("Primary Key is null");
        }
        return new QueryPKDevice<T>(this.manager, entryCls, primarykey);
    }

    public QueryEN query(Collection<? extends BasicBean> entrys) {
        return new QueryENDevice(this.manager, entrys);
    }

    public Manager getManager() {
        return this.manager;
    }

    public DataInformation dataInformation() throws Exception {
        if (this.dataInformation != null) {
            return this.dataInformation;
        }
        switch (this.getManager().productType()) {
            case MYSQL: {
                this.dataInformation = new MySQLInfomation(this);
                break;
            }
            case MICROSOFT_SQL_SERVER: {
                this.dataInformation = new MSInfomation(this);
                break;
            }
            case SQLITE: {
                this.dataInformation = new SQLiteInfomation(this);
                break;
            }
            case ORACLE: {
                this.dataInformation = new OracleInfomation(this);
                break;
            }
            default: {
                throw new CdmSupportsException(this.getManager().productType());
            }
        }
        return this.dataInformation;
    }

    public QueryMap query(String tableName, Map<String, Object> entry) {
        if (entry == null || entry.isEmpty()) {
            throw new NullPointerException("Entry is null or empty.");
        }
        return new QueryMapDevice(this.manager, tableName, entry);
    }

    public QueryMap query(String tableName, Collection<Map<String, Object>> entrys) {
        if (entrys == null || entrys.isEmpty()) {
            throw new NullPointerException("Entrys is null or empty.");
        }
        return new QueryMapDevice(this.manager, tableName, entrys);
    }

    public <T extends BasicBean> QueryTB query(Class<T> cls) {
        return this.query(Cdm.tableName(cls));
    }

    public void bindTransaction(TransactionFactory factory) {
        this.manager.getTemplate().bindTransaction(factory);
    }
}

