/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Assert;
import com.mhdt.toolkit.Reflect;
import java.util.List;
import java.util.function.Consumer;
import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Cdm;
import online.sanen.cdm.basic.CdmQueryException;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.factory.BootStrapFactoty;

public interface Behavior
extends BasicBean {
    default public Bootstrap bootstrap() {
        if (BootStrapFactoty.isUniqueness()) {
            return BootStrapFactoty.getFirst();
        }
        String bootstrapId = Reflect.getBootStrapId(this.getClass());
        Assert.notNull((Object)bootstrapId, (String)("class:" + this.getClass().getName() + " There is no injected bootstrap instance, please use the bootstrap annotation or rewrite the getBootstrap method."));
        if (BootStrapFactoty.contains(bootstrapId)) {
            return BootStrapFactoty.get(bootstrapId);
        }
        throw new NullPointerException("BootstrapId: '" + bootstrapId + "' index instance cannot be passed by class:" + this.getClass().getName());
    }

    default public int insert() {
        return this.bootstrap().query((BasicBean)this).insert();
    }

    default public int delete() {
        return this.bootstrap().query((BasicBean)this).delete();
    }

    default public int update() {
        return this.bootstrap().query((BasicBean)this).update();
    }

    default public int updateByFields(String ... fields) {
        return this.bootstrap().query((BasicBean)this).setFields(fields).update();
    }

    default public int updateByExceptFields(String ... fields) {
        return this.bootstrap().query((BasicBean)this).setExceptFields(fields).update();
    }

    default public <T extends Behavior> T findByPk() {
        try {
            Object primary = Reflect.getValue((Object)this, (String)(this.primarykey() == null ? "id" : this.primarykey()));
            return (T)((Behavior)this.bootstrap().query(this.getClass(), primary).find());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    default public <T extends Behavior> T findByConditions(Consumer<List<Condition>> conditions) {
        return (T)((Behavior)this.bootstrap().query(this.getClass()).addCondition(conditions).addEntry(this.getClass()).unique());
    }

    default public <T extends Behavior> T findByField(String ... fields) {
        return (T)((Behavior)this.bootstrap().query(this.getClass()).addCondition(conditions -> {
            for (String fieldName : fields) {
                if (!Validate.hasField(this.getClass(), (String)fieldName)) continue;
                try {
                    conditions.add(Condition.builder((String)fieldName, (Condition.Conditions)Condition.Conditions.EQUALS, (Object)Reflect.getValue((Object)this, (String)fieldName)));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        }).addEntry(this.getClass()).unique());
    }

    default public int createTable() {
        if (!this.bootstrap().query(Cdm.tableName(this.getClass())).isExsites()) {
            return this.bootstrap().query((BasicBean)this).create();
        }
        return -1;
    }

    default public int dropTable() {
        String tableName = Cdm.tableName(this.getClass());
        if (this.bootstrap().query(tableName).isExsites()) {
            return this.bootstrap().query(tableName).drop();
        }
        return -1;
    }

    public static <T extends Behavior> List<T> list(Class<T> cls) {
        Bootstrap bootstrap = BootStrapFactoty.isUniqueness() ? BootStrapFactoty.getFirst() : BootStrapFactoty.get(Reflect.getBootStrapId(cls));
        return bootstrap.query(cls).addEntry(cls).list();
    }

    public static <T extends Behavior> List<T> listByConditions(Class<T> cls, Consumer<List<Condition>> consumer) {
        Bootstrap bootstrap = BootStrapFactoty.isUniqueness() ? BootStrapFactoty.getFirst() : BootStrapFactoty.get(Reflect.getBootStrapId(cls));
        return bootstrap.query(cls).addEntry(cls).addCondition(consumer).list();
    }

    public static <T extends Behavior> List<T> listByFields(T t, String ... fields) {
        Bootstrap bootstrap = BootStrapFactoty.isUniqueness() ? BootStrapFactoty.getFirst() : BootStrapFactoty.get(Reflect.getBootStrapId(t.getClass()));
        return bootstrap.query(t.getClass()).addEntry(t.getClass()).addCondition(conditions -> {
            for (String fieldName : fields) {
                if (!Validate.hasField(t.getClass(), (String)fieldName)) continue;
                try {
                    conditions.add(Condition.builder((String)fieldName, (Condition.Conditions)Condition.Conditions.EQUALS, (Object)Reflect.getValue((Object)t, (String)fieldName)));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        }).list();
    }

    public static <T extends Behavior> int batchInsert(List<T> list) throws CdmQueryException {
        Bootstrap bootstrap;
        Bootstrap bootstrap2 = bootstrap = BootStrapFactoty.isUniqueness() ? BootStrapFactoty.getFirst() : BootStrapFactoty.get(Reflect.getBootStrapId(((Behavior)list.get(0)).getClass()));
        if (list != null && !list.isEmpty()) {
            return bootstrap.query(list).insert();
        }
        throw new CdmQueryException("list is null or is Empty");
    }

    public static <T extends Behavior> int delete(Class<T> cls, Consumer<List<Condition>> conditions) throws CdmQueryException {
        Bootstrap bootstrap = BootStrapFactoty.isUniqueness() ? BootStrapFactoty.getFirst() : BootStrapFactoty.get(Reflect.getBootStrapId(cls));
        return bootstrap.query(cls).addCondition(conditions).delete();
    }
}

