/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm;

import com.mhdt.Print;
import online.sanen.cdm.CacheUtil;
import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.factory.PipelineFactory;

public class Assembler {
    public static Object create(QueryType queryType, ResultType resultType, Structure structure, PipelineFactory factory) {
        long lastTime = System.currentTimeMillis();
        structure.setQueryType(queryType);
        structure.setResultType(resultType);
        Object result = null;
        Pipeline pipeline = factory.getPipeline();
        for (Handel handel : pipeline.getHandels()) {
            Object obj = handel.handel(structure, result);
            Object object = result = obj == null ? result : obj;
            if (pipeline.getLast() != handel) continue;
            Assembler.print(lastTime, structure);
            return result;
        }
        return null;
    }

    private static void print(long lastTime, Structure structure) {
        if (structure.isShowSql()) {
            String temp = "elapsed time:" + (float)(System.currentTimeMillis() - lastTime) / 1000.0f + "s ";
            if (structure.isCache() && structure.getQueryType().equals((Object)QueryType.select)) {
                temp = temp + "\tcache:" + CacheUtil.getInstance().getCacheInfo(structure);
            }
            Print.out((Object)(temp + "\r\n"), (String)"WHITE");
        }
    }
}

