package online.sanen.cdm.infomation;

import java.sql.SQLException;
import java.util.List;

import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.DataInformation;
import online.sanen.cdm.basic.DataField;

/**
 * 
 * @author LazyToShow 
 * Date: 2018/06/12 
 * Time: 09:17
 */
public class MySQLInfomation extends DataInformation {

	Bootstrap bootstrap;

	public MySQLInfomation(Bootstrap bootstrap) {
		super(bootstrap);
	}

	@Override
	public List<String> getDatabases() {
		String sql = "show databases";
		return bootstrap.createSQL(sql).list();
	}

	@Override
	public List<String> getTableNames() throws SQLException {

		String sql = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA =?";
		return bootstrap.createSQL(sql, bootstrap.getManager().databaseName()).list();
	}

	@Override
	public List<DataField> getFields(String tableName) throws SQLException {

		String sql = "SELECT COLUMN_NAME name,DATA_TYPE type,COLUMN_COMMENT comment,COLUMN_KEY  from"
				+ " information_schema.`COLUMNS` "
				+ "WHERE TABLE_NAME=? and TABLE_SCHEMA=?";

		return bootstrap.createSQL(sql, tableName, bootstrap.getManager().databaseName()).addEntry(DataField.class)
				.list();
	}

}
