package online.sanen.cdm.handel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;

import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.CdmQueryException;
import online.sanen.cdm.basic.DataField;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.template.JdbcTemplate;

/**
 * 
 * 从Sql语句中提取字段信息
 *
 * @author LazyToShow <br>
 *         Date: 2018年9月10日 <br>
 *         Time: 下午9:31:42
 */
public class SqlColumns implements Handel {

	@Override
	public Object handel(Structure structure, Object product) {

		String sql = structure.getSql().toString();

		JdbcTemplate template = (JdbcTemplate) structure.getTemplate();

		try (Connection connection = template.getDataSource().getConnection()) {

			PreparedStatement ps = connection.prepareStatement(sql, ResultSet.TYPE_FORWARD_ONLY,
					ResultSet.CONCUR_READ_ONLY);

			initFetchSize(ps, structure.productType());

			ResultSet rs = ps.executeQuery();

			// Assembly fields
			ResultSetMetaData metaData = rs.getMetaData();

			List<DataField> dataFields = new ArrayList<>();

			for (int i = 0; i < metaData.getColumnCount(); i++) {

				DataField dataField = new DataField();

				dataField.setName(metaData.getColumnLabel(i + 1));
				dataField.setCls(Class.forName(metaData.getColumnClassName(i + 1)));
				dataField.setType(metaData.getColumnTypeName(i + 1));
				dataFields.add(dataField);

			}

			return dataFields;

		} catch (Exception e) {
			throw new CdmQueryException(e);

		}

	}

}
