package online.sanen.cdm.handel;

import com.mhdt.Print;
import com.mhdt.toolkit.DateUtility;

import online.sanen.cdm.basic.Structure;

public class DebugHandel extends DefaultHandel {

	static int lastTime;

	static StringBuilder sb = new StringBuilder();

	@Override
	public Object handel(Structure structure, Object product) {

		if (structure.isShowSql()) {
			
			if (DateUtility.getNowForInt() > lastTime + 10) {
				
				Print.out("\r\n[" + DateUtility.getNow() + "]", "BLACK");
				
				lastTime = DateUtility.getNowForInt();
			}
			
			sb.append(structure.isFormatSql() ? formatSql(structure) : getSql(structure));
			Print.out(sb.toString(), "CYAN");
			sb.setLength(0);
			
			Print.out(
					"-------------------------------------------------------------------------------------------------------",
					"WHITE");

		}

		if (structure.isLog()) {

		}

		return null;
	}

}
