package online.sanen.cdm.handel;

import java.util.Collection;

import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.ProductType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.condition.Condition.Associated;
import online.sanen.cdm.condition.Condition.Conditions;

/**
 * <pre>
 * 
 * &#64;author LazyToShow
 * Date: 2017/10/21 
 * Time: 23:19
 * </pre>
 */
public class ConditionHandel implements Handel {

	@Override
	public Object handel(Structure structure, Object product) {
		processCondition(structure);
		return null;
	}

	private void processCondition(Structure structure) {
		
		if (structure.getConditions() == null || structure.getConditions().isEmpty())
			return;
		
		structure.getSql().append(" WHERE ");
		String modifier = ProductType.applyTableModifier(structure.productType());

		for (Condition condition : structure.getConditions()) {

			processPefix(structure.getSql(), condition);

			if (condition.getCondition() == Conditions.CONTAINS 
					|| condition.getCondition() == Conditions.NO_CONTAINS
					|| condition.getCondition() == Conditions.START_WITH
					|| condition.getCondition() == Conditions.END_WITH) {
				
				try {
					structure.getSql().append(modifier + condition.getFieldName() + modifier
							+ condition.getCondition().annotation.replace("?", condition.getValue().toString()));
				}catch (NullPointerException e) {
					throw new CdmConditionException("Condition value is null ,"+condition.toString(),e);
				}
				
				
			} else if (condition.getCondition() == Conditions.IN || condition.getCondition() == Conditions.NOT_IN) {
				structure.getSql().append(modifier + condition.getFieldName() + modifier
						+ condition.getCondition().annotation.replace("?", processParamersOfIn(condition.getValue())));
				structure.addParamer(condition.getValue());

			} else if (condition.getCondition() == Conditions.MATCH) {

				structure.getSql().append("match(" + modifier + condition.getFieldName() + modifier + ")"
						+ condition.getCondition().annotation);
				structure.addParamer(condition.getValue());
			} else if(condition.getCondition() == Conditions.IS_EMPTY || condition.getCondition() == Conditions.IS_NULL
					|| condition.getCondition() == Conditions.IS_NOT_EMPTY
					|| condition.getCondition() == Conditions.IS_NOT_NULL){
				structure.getSql().append(modifier + condition.getFieldName() + modifier + condition.getCondition().annotation);
			}else {
				structure.getSql()
						.append(modifier + condition.getFieldName() + modifier + condition.getCondition().annotation);
				structure.addParamer(condition);

			}

		}
		

	}

	/**
	 * (?,?,?)
	 * 
	 * @param value
	 * @return
	 */
	private CharSequence processParamersOfIn(Object value) {

		if (value.getClass().isArray()) {
			Object[] array = (Object[]) value;
			StringBuilder sql = new StringBuilder();

			for (int i = 0; i < array.length; i++)
				sql.append("?,");

			sql.setLength(sql.length() - 1);

			return sql.toString();

		} else if (value instanceof Collection) {

			@SuppressWarnings("unchecked")
			Collection<Object> array = (Collection<Object>) value;
			StringBuilder sql = new StringBuilder();

			for (int i = 0; i < array.size(); i++)
				sql.append("?,");

			sql.setLength(sql.length() - 1);

			return sql.toString();

		} else {
			return "?";
		}
	}

	private void processPefix(StringBuilder sql, Condition condition) {

		if (sql.toString().endsWith(" WHERE "))
			return;


		if (!(condition.getAssociated() == Associated.AND)) {
			sql.append(" OR ");
		} else {
			sql.append(" AND ");
		}

	}

}
