package online.sanen.cdm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.condition.Condition.Conditions;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;

public class QueryUPDevice implements QueryUP {
	
	Structure structure;

	public QueryUPDevice(Structure structure) {
		this.structure = structure;
	}

	@Override
	public QueryUP setTableName(String tableName) {
		structure.setTableName(tableName);
		return this;
	}

	@Override
	public QueryUP setFields(String... fields) {
		structure.setFields(new HashSet<>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions) {
		try {
			structure.addCondition(Condition.builder(fieldName, conditions));
		} catch (CdmConditionException e) {
			e.printStackTrace();
		}
		return this;
	}

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions, Object value) {
		structure.addCondition(Condition.builder(fieldName, conditions,value));
		return this;
	}
	
	
	@Override
	public QueryUP addCondition(Consumer<List<Condition>> consumer) {
		consumer.accept(structure.getConditions());
		return this;
	}

	@Override
	public QueryUP setExceptFields(String... fields) {
		structure.setFields(new HashSet<>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public int update() {
		return (int) Assembler.create(QueryType.update, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.commonFieldHandel());
				pipeline.addLast(HandelFactory.sqlHandel());
				pipeline.addLast(HandelFactory.paramerHandel());
				pipeline.addLast(HandelFactory.conditionHandel());
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	
}
