package online.sanen.cdm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.CdmConditionException;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.condition.Condition.Conditions;
import online.sanen.cdm.factory.HandelFactory;
import online.sanen.cdm.factory.PipelineFactory;

/**
 * 
 * @author online.sanen Date: 2017/11/25 Time： 9：24
 */
public class QueryENDevice implements QueryEN {

	Structure structure;

	public QueryENDevice(Manager manager, BasicBean entry) {
		structure = new Structure(manager);
		structure.setEntry(entry);
	}

	public QueryENDevice(Manager manager, Collection<BasicBean> entrys) {
		structure = new Structure(manager);
		structure.setEntrys(entrys);
	}

	@Override
	public QueryEN setTableName(String tableName) {
		structure.setTableName(tableName);
		return this;
	}

	@Override
	public QueryEN setFields(String... fields) {
		structure.setFields(new HashSet<String>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public QueryEN setExceptFields(String... fields) {
		structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public int insert() {

		if (structure.getEntrys() != null)
			return batchUpdate(QueryType.insert);

		return (int) Assembler.create(QueryType.insert, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {

				Pipeline pipeline = new PipelineDivice();

				pipeline.addLast(HandelFactory.commonFieldHandel());
				pipeline.addLast(HandelFactory.sqlHandel());
				pipeline.addLast(HandelFactory.paramerHandel());
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());

				return pipeline;

			}
		});
	}

	@Override
	public int delete() {

		if (structure.getEntrys() != null)
			return batchUpdate(QueryType.delete);

		return (int) Assembler.create(QueryType.delete, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.sqlHandel());
				pipeline.addLast(HandelFactory.primaryKeyHandel());
				pipeline.addLast(HandelFactory.conditionHandel());
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	@Override
	public int update() {

		if (structure.getEntrys() != null)
			return batchUpdate(QueryType.update);

		return (int) Assembler.create(QueryType.update, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.commonFieldHandel());
				pipeline.addLast(HandelFactory.sqlHandel());
				pipeline.addLast(HandelFactory.paramerHandel());
				pipeline.addLast(HandelFactory.primaryKeyHandel());
				pipeline.addLast(HandelFactory.conditionHandel());
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	private int batchUpdate(QueryType type) {
		return (int) Assembler.create(type, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.commonFieldHandel());
				pipeline.addLast(HandelFactory.sqlHandel());
				pipeline.addLast(HandelFactory.batchUpdate());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
	}

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions) {
		try {
			structure.addCondition(Condition.builder(fieldName, conditions));
		} catch (CdmConditionException e) {
			e.printStackTrace();
		}

		return new QueryUPDevice(structure);
	}
	

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions, Object value) {
		structure.addCondition(Condition.builder(fieldName, conditions, value));
		return new QueryUPDevice(structure);
	}

	
	@Override
	public QueryUP addCondition(Consumer<List<Condition>> consumer) {
		consumer.accept(structure.getConditions());
		return new QueryUPDevice(structure);
	}

	@Override
	public int create() {
		
		return (int) Assembler.create(QueryType.create, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(HandelFactory.sqlHandel());
				pipeline.addLast(HandelFactory.resultHandel());
				pipeline.addLast(HandelFactory.debugHandel());
				return pipeline;
			}
		});
		
	}


}
