package online.sanen.cdm;

import java.util.Collection;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mhdt.analyse.Template;
import com.mhdt.analyse.Validate;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Cdm;
import online.sanen.cdm.basic.CdmSupportsException;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.infomation.MSInfomation;
import online.sanen.cdm.infomation.MySQLInfomation;
import online.sanen.cdm.infomation.OracleInfomation;
import online.sanen.cdm.infomation.SQLiteInfomation;
import online.sanen.cdm.template.JdbcTemplate;
import online.sanen.cdm.template.transaction.TransactionFactory;

/**
 * 
 * @author online.sanen <br>
 *         Date: 2017/10/21 <br>
 *         Time: 23:19
 */
public class BootstrapDevice implements Bootstrap {

	final Logger logger = LoggerFactory.getLogger(Bootstrap.class);

	Manager manager;

	public BootstrapDevice(JdbcTemplate jdbcTemplate) throws Exception {
		this(jdbcTemplate, true);
	}

	public BootstrapDevice(JdbcTemplate jdbcTemplate, boolean isShowSql) throws Exception {
		this(jdbcTemplate, isShowSql, false, false);
	}

	public BootstrapDevice(JdbcTemplate jdbctemplate, boolean isShowSql, boolean isCache, boolean isLog)
			throws Exception {
		
		manager = new ManagerDevice();
		setIsShowSql(isShowSql);
		setIsCache(isCache);
		setIsLog(isLog);
		setTemplate(jdbctemplate);
		if (isLog)
			System.err.println(manager);
	}



	boolean isLog;

	public boolean isLog() {
		return isLog;
	}

	public void setIsLog(boolean isLog) {
		this.isLog = isLog;
	}

	JdbcTemplate template;

	public void setTemplate(JdbcTemplate template) throws Exception {

		manager.setTemplate(template);

		if (isLog()) {
			Template tem = new Template(BootstrapDevice.class.getResourceAsStream("info.template"));
			tem.setParamer("dataBase", manager.productType().toString());
			tem.setParamer("url", manager.getUrl());
			logger.info(tem.getText());
		}

	}

	boolean isSqlFormat;

	public void setIsSqlFormat(boolean isSqlFormat) {
		manager.setSqlFormat(isSqlFormat);
	}

	boolean isShowSql;

	public void setIsShowSql(Boolean isShowSql) {
		manager.setIsShowSql(isShowSql);
	}

	boolean isCache;

	public void setIsCache(Boolean isCache) {
		manager.setIsCache(isCache);
	}
	

	@Override
	public QuerySQL createSQL(String sql, Object... paramers) {

		if (Validate.isNullOrEmpty(sql))
			throw new NullPointerException("Sql is null");

		return new QuerySQLDevice(manager, sql, paramers);
	}

	@Override
	public QuerySQL createSQL(String sql) {

		if (Validate.isNullOrEmpty(sql))
			throw new NullPointerException("Sql is null");

		return new QuerySQLDevice(manager, sql);
	}

	@Override
	public QueryEN query(BasicBean entry) {

		if (entry == null)
			throw new NullPointerException("Entry is null");

		if (manager == null)
			throw new NullPointerException("manager is null");

		return new QueryENDevice(manager, entry);
	}

	@Override
	public QueryTB query(String tableName) {

		if (Validate.isNullOrEmpty(tableName))
			throw new NullPointerException("Table is null");

		return new QueryTBDevice(manager, tableName);
	}

	@Override
	public <T extends BasicBean> QueryPK<T> query(Class<T> entryCls, Object primarykey) {

		if (entryCls == null)
			throw new NullPointerException("Entry class is null");

		if (primarykey == null)
			throw new NullPointerException("Primary Key is null");

		return new QueryPKDevice<T>(manager, entryCls, primarykey);
	}

	@SuppressWarnings("unchecked")
	@Override
	public QueryEN query(Collection<? extends BasicBean> entrys) {
		return new QueryENDevice(manager, (Collection<BasicBean>) entrys);
	}

	@Override
	public Manager getManager() {
		return manager;
	}

	DataInformation dataInformation;

	@Override
	public DataInformation dataInformation() throws Exception {

		if (dataInformation != null)
			return dataInformation;

		switch (getManager().productType()) {
		case MYSQL:
			dataInformation = new MySQLInfomation(this);
			break;

		case MICROSOFT_SQL_SERVER:
			dataInformation = new MSInfomation(this);
			break;

		case SQLITE:
			dataInformation = new SQLiteInfomation(this);
			break;

		case ORACLE:
			dataInformation = new OracleInfomation(this);
			break;

		default:
			throw new CdmSupportsException(getManager().productType());
		}

		return dataInformation;
	}

	@Override
	public QueryMap query(String tableName, Map<String, Object> entry) {
		if (entry == null || entry.isEmpty())
			throw new NullPointerException("Entry is null or empty.");

		return new QueryMapDevice(manager, tableName, entry);
	}

	@Override
	public QueryMap query(String tableName, Collection<Map<String, Object>> entrys) {
		if (entrys == null || entrys.isEmpty())
			throw new NullPointerException("Entrys is null or empty.");

		return new QueryMapDevice(manager, tableName, entrys);
	}

	@Override
	public <T extends BasicBean> QueryTB query(Class<T> cls) {
		return query(Cdm.tableName(cls));
	}

	@Override
	public void bindTransaction(TransactionFactory factory) {
		manager.getTemplate().bindTransaction(factory);
	}

}
