package online.sanen.cdm.handel;

import com.mhdt.toolkit.Reflect;

import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Condition;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.basic.Condition.Conditions;

/**
 * <pre>
 * @author LazyToShow
 * Date: 2017/11/23
 * Time: 16:15
 * </pre>
 */
public class PrimaryKeyHandel implements Handel{

	@Override
	public Object handel(Structure structure,Object product) {
		
		//Get entry
		BasicBean basicBean = structure.getEntry();
		
		if(basicBean==null) {
			
			try {
				Class<?> cls = structure.getEntry_class();
				basicBean = (BasicBean) Reflect.newInstance(cls.getName());
			} catch (InstantiationException | IllegalAccessException | ClassNotFoundException  e) {
				e.printStackTrace();
			}
			
		}
		
		//Add primary key condition
		
		try {
			
			String key = basicBean.getPrimarykey()==null?"id":basicBean.getPrimarykey();
			Object value = structure.getPrimaryValue()==null?
					Reflect.getInject(basicBean, key):structure.getPrimaryValue();
					structure.addCondition(new Condition(key,Conditions.EQUALS, value));
					
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return null;
	}
	
	
	

}
