package online.sanen.cdm.handel;

import java.sql.SQLException;

import online.sanen.cdm.basic.QueryException;
import online.sanen.cdm.basic.Structure;

/**
 * 
 * @author 懒得出风头 Date: 2017/10/21 Time: 23:19
 */
public class LimitHandel extends DefaultHandel {

	@Override
	public Object handel(Structure structure, Object product) throws QueryException, SQLException {
		// The tag needs to be treated with limit.
		structure.setHasLimitAble(true);

		switch (structure.getProductName()) {
		case "MYSQL":
			structure.isSupportLimit(true);
			proceessMysqlLimit(structure);
			break;

		case "MICROSOFT SQL SERVER":
			structure.isSupportLimit(true);
			proceessSqlServerLimit(structure);
			break;

		default:
			// Marked as a temporary unsupported SQL limit, which is handled by the
			// resultHandel general method.
			structure.isSupportLimit(false);
			break;
		}
		return null;
	}

	private void proceessSqlServerLimit(Structure structure) {
		Integer[] limit = structure.getLimit();
		structure.getSql().replace(0, 6, "select top " + limit[0]);
	}

	private void proceessMysqlLimit(Structure structure) {

		Integer[] limit = structure.getLimit();

		structure.getSql().append(" limit " + limit[0]);
		if (limit.length>1 && limit[1] != null && limit[1] > 0)
			structure.getSql().append("," + limit[1]);

	}

}
