package online.sanen.cdm.handel;

import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.Condition;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.basic.Condition.Conditions;

/**
 * <pre>
 * 
 * @author LazyToShow
 * Date: 2017/10/21 
 * Time: 23:19
 * </pre>
 */
public class ConditionHandel implements Handel {

	@Override
	public Object handel(Structure structure,Object product) {
		processCondition(structure);
		return null;
	}

	private void processCondition(Structure structure) {

		if (structure.getConditions() == null || structure.getConditions().isEmpty())
			return;
		
		structure.getSql().append(" where ");

		for (Condition condition : structure.getConditions()) {
			
			if (	
					condition.getOption() == Conditions.CONTAINS || 
					condition.getOption() == Conditions.NO_CONTAINS	|| 
					condition.getOption() == Conditions.START_WITH || 
					condition.getOption() == Conditions.END_WITH
				){

				structure.getSql().append(" "+condition.getFieldName()
						+ condition.getOption().annotation.replace("?", condition.getValue().toString()) + " and");
				continue;
			}

			
			if(condition.getOption() == Conditions.IN) {
				structure.getSql().append(" " + condition.getFieldName() + condition.getOption().annotation.replace("?", condition.getValue().toString()) + " and");
				continue;
			}

			if (condition.getOption() == Conditions.MATCH) {
				structure.getSql()
						.append(" match(" + condition.getFieldName() + ")" + condition.getOption().annotation + " and");
			} else {
				structure.getSql().append(" " + condition.getFieldName() + condition.getOption().annotation + " and");
			}

			structure.addParamer(condition.getValue());
		}
		
		if(structure.getSql().toString().endsWith("and")) 
			structure.getSql().setLength(structure.getSql().length()-3);
		
		if(structure.getSql().toString().endsWith(" where ")) 
			structure.getSql().setLength(structure.getSql().length()-7);
		
	}

}
