package online.sanen.cdm.factory;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import online.sanen.cdm.Obstract;

public class DataSources {

	public static DataSource create(final Obstract obstract) throws Exception {

		
		switch (obstract.getType()) {
		
		case Druid:
			return DruidDataSourceFactory.createDataSource(createProperties(obstract));
			
		default:
			return BasicDataSourceFactory.createDataSource(createProperties(obstract));
		}

	}
	
	private static Properties createProperties(Obstract obstract) {
		return new Properties() {
			private static final long serialVersionUID = 1L;
			{
				setProperty("driverClassName", obstract.getDriver());
				setProperty("url", obstract.getUrl());
				setProperty("username", obstract.getUsername());
				setProperty("password", obstract.getPassword());
				setProperty("validationQuery", "select 1");
			}
		};
	}

}
