package online.sanen.cdm;

import java.util.List;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.SqlConditionException;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.Handels;
import online.sanen.cdm.factory.PipelineFactory;
import online.sanen.cdm.resource.R;

/**
 * 
 * <pre>
 *
 * @author online.sanen
 * Date:2017年11月30日
 * Time:下午8:37:20
 * </pre>
 */
public class QuerySQLDevice implements QuerySQL {

	Structure structure;

	public QuerySQLDevice(Manager manager, String sql, Object... paramers)  {
		structure = new Structure(manager);
		structure.setSql(sql);
		addParamers(paramers);
	}

	@Override
	public QuerySQL addParamer(int index, Object paramer) {

		if (index < 1)
			try {
				throw new SqlConditionException(R.strings.Exception_Parametric_Anomaly);
			} catch (SqlConditionException e) {
				e.printStackTrace();
			}

		if (paramer == null)
			try {
				throw new SqlConditionException(R.strings.Exception_Parametric_Null);
			} catch (SqlConditionException e) {
				e.printStackTrace();
			}

		structure.addParamer(index, paramer);
		return this;
	}

	@Override
	public QuerySQL addEntry(Class<? extends BasicBean> entry) {

		if (entry == null)
			try {
				throw new SqlConditionException(R.strings.Exception_EntryClass_Null);
			} catch (SqlConditionException e) {
				e.printStackTrace();
			}

		structure.setEntry_class(entry);
		return this;
	}

	@Override
	public int update() {

		return (int) Assembler.create(QueryType.update, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<?> list() {
		return (List<?>) Assembler.create(QueryType.select, ResultType.List, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@SuppressWarnings("unchecked")
	@Override
	public Object uniqueResult() {
		return Assembler.create(QueryType.select, ResultType.Object, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	private void addParamers(Object[] paramers)  {
		if (paramers != null) {
			for (int i = 0; i < paramers.length; i++) {
				addParamer(i + 1, paramers[i]);
			}
		}
	}

}
