package online.sanen.cdm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Condition;
import online.sanen.cdm.basic.Condition.Conditions;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.SqlConditionException;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.Handels;
import online.sanen.cdm.factory.PipelineFactory;

/**
 * 
 * @author online.sanen
 * Date: 2017/11/25
 * Time： 9：24
 */
public class QueryENDevice implements QueryEN {

	Structure structure;

	public QueryENDevice(Manager manager, BasicBean entry) {
		structure = new Structure(manager);
		structure.setEntry(entry);
	}


	public QueryENDevice(Manager manager, Collection<BasicBean> entrys) {
		structure = new Structure(manager);
		structure.setEntrys(entrys);
	}

	@Override
	public QueryEN setTableName(String tableName) {
		structure.setTableName(tableName);
		return this;
	}

	@Override
	public QueryEN setFields(String... fields) {
		structure.setFields(new HashSet<String>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public QueryEN setExceptFields(String... fields) {
		structure.setExceptes(new HashSet<String>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public int insert() {
		
		if(structure.getEntrys()!=null) 
			return batchUpdate(QueryType.insert);
		
		return (int) Assembler.create(QueryType.insert, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				
				Pipeline pipeline = new PipelineDivice();
				
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				
				return pipeline;
				
			}
		});
	}

	@Override
	public int remove() {
		
		if(structure.getEntrys()!=null) 
			return batchUpdate(QueryType.remove);
		
		return (int) Assembler.create(QueryType.remove, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.primaryKeyHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@Override
	public int update() {
		
		if(structure.getEntrys()!=null) 
			return batchUpdate(QueryType.update);
		
		return (int) Assembler.create(QueryType.update, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.primaryKeyHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}


	private int batchUpdate(QueryType type) {
		return (int) Assembler.create(type, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.batchUpdate());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}


	@Override
	public QueryUpdate addCondition(String fieldName, Conditions conditions) {
		try {
			structure.addCondition(new Condition(fieldName, conditions));
		} catch (SqlConditionException e) {
			e.printStackTrace();
		}
		
		return new QueryUpdateDevice(structure);
	}


	@Override
	public QueryUpdate addCondition(String fieldName, Conditions conditions, Object value) {
		structure.addCondition(new Condition(fieldName, conditions, value));
		return new QueryUpdateDevice(structure);
	}


	@Override
	public QueryUpdate addCondition(Condition... conditions) {
		for(Condition condition : conditions) {
			structure.addCondition(condition);
		}
		return new QueryUpdateDevice(structure);
	}

}
