package online.sanen.cdm;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;

import online.sanen.cdm.basic.CDMConnectionException;
import online.sanen.cdm.component.Manager;

/**
 * 
 * @author LazyToShow
 * Date: 2017/10/21 
 * Time: 23:19
 */
public class ManagerDevice implements Manager {

	JdbcTemplate template;


	@Override
	public void setTemplate(JdbcTemplate template) {
		this.template = template;
	}

	boolean isShowSql;

	@Override
	public boolean isShowSql() {
		return isShowSql;
	}

	public void setIsShowSql(boolean flag) {
		isShowSql = flag;
	}

	public JdbcTemplate getTemplate() {
		return template;
	}

	String productName;

	@Override
	public String getProductName() throws SQLException {

		if (productName == null) {
			JdbcTemplate template = null;
			DataSource dataSource = null;
			Connection connection = null;
			try {
				template = getTemplate();
				dataSource = template.getDataSource();
				connection =  dataSource.getConnection();
				productName = connection.getMetaData().getDatabaseProductName().toUpperCase();
			}catch (NullPointerException e) {
				String str = null;
				
				if(template ==null)
					str = "template";
				else if(dataSource == null)
					str = "dataSource";
				else if(connection == null)
					str = "connection";
				
				throw new CDMConnectionException("Unable to read database. Because "+str+" is null.Please confirm whether the connection pool is incorrect.");
			}
		}

		return productName;
	}
	
	@Override
	public String getDatabaseName() {
		try {
			return  template.getDataSource().getConnection().getCatalog();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	boolean isCache = true;

	@Override
	public void setIsCache(boolean isCache) {
		this.isCache = isCache;
	}

	@Override
	public boolean isCache() {
		return isCache;
	}

	boolean isLog;

	public boolean isLog() {
		return isLog;
	}

	public void setLog(boolean isLog) {
		this.isLog = isLog;
	}

	boolean sqlFormat = true;

	@Override
	public void setSqlFormat(boolean isFormat) {
		sqlFormat = isFormat;
	}

	@Override
	public boolean getSqlFormat() {
		return sqlFormat;
	}

	@Override
	public String toString() {
		try {
			
			return "BootStrap Manager Configuration information "
					+template.getDataSource().getConnection().getMetaData().getURL()
					+"\r\n[isShowSql:" + isShowSql + ", isCache:" + isCache
					+ ", sqlFormat:" + sqlFormat + ", isLog:" + isLog + "]";
			
			
		} catch (SQLException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public void setIsLog(boolean isLog) {
		this.isLog = isLog;
	}

	@Override
	public String getUrl() {
		try {
			return ((JdbcTemplate)getTemplate()).getDataSource().getConnection().getMetaData().getURL();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return productName;
	}
	
	

}
