package online.sanen.cdm;

import java.sql.SQLException;
import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

import com.mhdt.analyse.Template;
import com.mhdt.analyse.Validate;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.component.Manager;

/**
 * <pre>
 * @author online.sanen 
 * Date: 2017/10/21 
 * Time: 23:19
 * </pre>
 */
public class BootstrapDevice implements Bootstrap {

	final Logger logger = LoggerFactory.getLogger(Bootstrap.class);

	Manager manager;

	public BootstrapDevice(JdbcTemplate jdbcTemplate) {
		this(jdbcTemplate, true);
	}

	public BootstrapDevice(JdbcTemplate jdbcTemplate, boolean debugEnabled) {
		this(jdbcTemplate, debugEnabled, false, false);
	}

	public BootstrapDevice(JdbcTemplate jdbctemplate, boolean isShowSql, boolean isCache, boolean isLog) {
			try {
				manager = new ManagerDevice();
				setTemplate(jdbctemplate);
				setIsShowSql(isShowSql);
				setIsCache(isCache);
				setIsLog(isLog);
				System.err.println(manager);
			} catch (Exception e) {
				e.printStackTrace();
			}
	}

	boolean isLog;

	public boolean isLog() {
		return isLog;
	}

	public void setIsLog(boolean isLog) {
		this.isLog = isLog;
	}

	JdbcTemplate template;

	public void setTemplate(JdbcTemplate template) throws SQLException {
			manager.setTemplate(template);
			Template tem = new Template(BootstrapDevice.class.getResourceAsStream("info.template"));
			tem.setParamer("dataBase", manager.getProductName());
			tem.setParamer("url",manager.getUrl());
			logger.info(tem.getText());

	}

	

	boolean isSqlFormat;

	public void setIsSqlFormat(boolean isSqlFormat) {
		manager.setSqlFormat(isSqlFormat);
	}

	boolean isShowSql;

	public void setIsShowSql(Boolean isShowSql) {
		manager.setIsShowSql(isShowSql);
	}

	boolean isCache;

	public void setIsCache(Boolean isCache) {
		manager.setIsCache(isCache);
	}

	@Override
	public QuerySQL createSQL(String sql, Object... paramers) {
		
		if(Validate.isNullOrEmpty(sql))
			throw new NullPointerException("Sql is null");
		
		return new QuerySQLDevice(manager, sql, paramers);
	}

	@Override
	public QuerySQL createSQL(String sql) {
		
		if(Validate.isNullOrEmpty(sql))
			throw new NullPointerException("Sql is null");
		
		return new QuerySQLDevice(manager, sql);
	}

	@Override
	public QueryEN query(BasicBean entry) {
		
		if(entry==null)
			throw new NullPointerException("Entry is null");
		
		return new QueryENDevice(manager, entry);
	}

	@Override
	public QueryTB query(String tableName) {
		
		if(Validate.isNullOrEmpty(tableName))
			throw new NullPointerException("Table is null");
		
		return new QueryTBDevice(manager, tableName);
	}

	@Override
	public <T extends BasicBean> QueryEC<T> query(Class<T> entryCls, Object primarykey) {
		
		if(entryCls==null)
			throw new NullPointerException("Entry class is null");
		
		if(primarykey==null)
			throw new NullPointerException("Primary Key is null");
		
		return new QueryECDevice<T>(manager, entryCls, primarykey);
	}

	@SuppressWarnings("unchecked")
	@Override
	public QueryEN query(Collection<? extends BasicBean> entrys) {
		return new QueryENDevice(manager, (Collection<BasicBean>) entrys);
	}

	@Override
	public Manager getManager() {
		return manager;
	}
}
