package online.sanen.cdm;

import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.factory.PipelineFactory;

/**
 * 
 * @author online.sanen
 * Date: 2017/10/21
 * Time: 23:19
 */
public class Assembler{
	
	/**
	 * 
	 * @param queryType 
	 * @param resultType
	 * @param structure
	 * @param factory
	 * @return
	 */
	public static Object create(QueryType queryType,ResultType resultType,Structure structure,PipelineFactory factory) {
		
		long lastTime = System.currentTimeMillis();
		structure.setQueryType(queryType);
		structure.setResultType(resultType);
		
		Object result = null;
		
		for(Handel handel : factory.getPipeline().getHandels()) {
			Object temp;
			try {
				temp = handel.handel(structure,result);
				result = (temp==null?result:temp);
				
				if(factory.getPipeline().getLast()==handel) {
					
					if(structure.isShowSql()) {
						System.out.print("elapsed time:"+(System.currentTimeMillis()-lastTime)/1000f+"s ");
						
						if(structure.isCache() && structure.getQueryType().equals(QueryType.select) )
							System.out.println("\tcache:"+CacheUtil.getInstance().getCacheInfo(structure));
						
						System.out.println();
					}
					return  result;
				}
					
			} catch (Exception e) {
				e.printStackTrace();
				break;
			}
			
			
		}
		
		return null;
		
	}

}
