package online.sanen.cdm.handel;

import com.mhdt.analyse.Validate;

import online.sanen.cdm.Handel;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.resource.R;

/**
 * 
 * @author 懒得出风头 Date: 2017/10/21 Time: 23:19
 */
public class SqlHandel implements Handel {

	@Override
	public Object handel(Structure structure,Object product) {
		
		//如果指定了sql 直接返回
		if(structure.getSql().length()>1)
			return null;

		//获取表名
		String tableName = structure.getTableName();
		
		//表名为空判定为严重异常，终止进程
		if (Validate.isNullOrEmpty(tableName))
			throw new RuntimeException(R.strings.Exception_TableName_Null);

		//根据query类别来生成Sql
		QueryType queryType = structure.getQueryType();

		switch (queryType) {
		case insert:
			createInsertSql(tableName,structure);
			break;

		case remove:
			createRemoveSql(tableName,structure);
			break;
		case update:
			createUpdateSql(tableName,structure);
			break;
			
		case select:
			createSelectSql(tableName,structure);
			break;
		}

		return null;
	}

	private void createSelectSql(String tableName, Structure structure) {
		
			StringBuilder sb = structure.getSql();
		
			sb.append("select ");
			for(String field : structure.getCommonFields()){
				sb.append(field+",");
			}
			sb.setLength(sb.length()-1);
			sb.append( " from "+tableName);
	}

	private void createUpdateSql(String tableName, Structure structure) {
		structure.getSql().append("update " + tableName + " set ");
		for (String field : structure.getCommonFields()) {
			structure.getSql().append( field + "=?,");
		}
		
		structure.getSql().setLength(structure.getSql().length()-1);
		
	}

	private void createRemoveSql(String tableName, Structure structure) {
		structure.getSql().append("delete from " + tableName);
	}

	private void createInsertSql(String tableName, Structure structure) {
		String sql = "insert into " + tableName + " (";
		String sql1 = " values (";
		for (String field : structure.getCommonFields()) {
			sql += field + ",";
			sql1 += "?,";
		}
		sql = sql.substring(0, sql.lastIndexOf(",")) + ")";
		sql1 = sql1.substring(0, sql1.lastIndexOf(",")) + ")";

		structure.getSql().append(sql+sql1);
	}

}
