package online.sanen.cdm.handel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.springframework.jdbc.core.JdbcTemplate;

import com.mhdt.analyse.Validate;
import com.mhdt.toolkit.Reflect;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.QueryException;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.Structure;

/**
 * 
 * @author 懒得出风头
 * Date: 2017/11/29
 * Time： 11：51
 */
public class BatchUpdate extends DefaultHandel{

	/**
	 * The original return value of batch operations is an int array,
	 *  and now it is omitted to return 1 or -1 to represent 
	 *  whether an exception has occurred
	 */
	@Override
	public Object handel(Structure structure, Object product) throws QueryException {
		try {
			if(structure.getEntrys()==null || structure.getEntrys().isEmpty())
				return new NullPointerException("Batch operation data source is null");
			
			BasicBean basicBean = structure.getEntrys().iterator().next();
			QueryType type = structure.getQueryType();
			JdbcTemplate template = structure.getJdbcTemplate();
			
			//Batch delete does not exist, this is to unify the interface to do the adaptation, 
			//delete the way to use in function, separate processing
			if(type.equals(QueryType.remove))
				return batchRemove(template, structure.getEntrys(), structure.getSql(), basicBean);
			
			//if update or insert should add where condition by primary key
			if(type.equals(QueryType.update))
				appendPrimaryCondition(structure.getSql(), basicBean);
			
			
			List<Object[]> batch = new ArrayList<>();
			
			
			for(BasicBean entry : structure.getEntrys()) {
				
				// if insert or update should add fields
				List<Object> paramers = new ArrayList<>();
				if(type.equals(QueryType.insert) || type.equals(QueryType.update)) 
					paramers.addAll(getValues(entry,structure.getCommonFields()));
					
				//if update  should add  primary key
				if(type.equals(QueryType.update))
					paramers.add(getPrimaryValua(entry));
					
				batch.add(paramers.toArray());
			}
			
			template.batchUpdate(structure.getSql().toString(), batch);
			return 1;
			
		}catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
		
	}

	/**
	 * Batch delete use in function
	 * @param template
	 * @param entrys
	 * @param sql
	 * @param basicBean
	 * @return
	 */
	private Object batchRemove(JdbcTemplate template,Collection<BasicBean> entrys,StringBuilder sql,BasicBean basicBean)  {
		try {
			String primaryKey = Validate.isNullOrEmpty(basicBean.getPrimarykey())?
					"id":basicBean.getPrimarykey();
			
			List<Object> paramers = new ArrayList<>();
			
			sql.append(" where "+primaryKey+" in(");
			for(BasicBean entry : entrys) {
				sql.append("?,");
				paramers.add(Reflect.getValue(entry, primaryKey));
			}
			
			sql.setLength(sql.length()-1);
			sql.append(")");
			
			template.update(sql.toString(),paramers.toArray());
			return 1;
		}catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
		
	}

	/**
	 * Add a primary key constraint
	 * @param sql
	 * @param basicBean
	 */
	private void appendPrimaryCondition(StringBuilder sql,BasicBean basicBean) {
		String primaryKey = Validate.isNullOrEmpty(basicBean.getPrimarykey())?
				"id":basicBean.getPrimarykey();
		
		sql.append(" where "+primaryKey+"=?");
	}

	/**
	 * Get the primary key
	 * @param basicBean
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws SecurityException
	 */
	private Object getPrimaryValua(BasicBean basicBean) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
		String primaryKey = Validate.isNullOrEmpty(basicBean.getPrimarykey())?
				"id":basicBean.getPrimarykey();
		return Reflect.getValue(basicBean, primaryKey);
	}

	/**
	 * Gets the value of the common field
	 * @param entry
	 * @param commonFields
	 * @return
	 */
	private List<Object> getValues(BasicBean entry, Set<String> commonFields) {
		List<Object> list = new ArrayList<>();
		
		try {
				
			for(String field : commonFields) {
				Field f = Reflect.getField(entry, field);
				f = (f == null ? Reflect.getFieldByColumnValue(entry, field) : f);
				list.add(f.get(entry));
			}
				
		} catch (Exception e) {
			e.printStackTrace();
		} 
		
		return list;
	}


}
