package online.sanen.cdm.factory;

import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;

import online.sanen.cdm.Bootstrap;
import online.sanen.cdm.BootstrapDevice;
import online.sanen.cdm.Connection;
import online.sanen.cdm.Obstract;

public class BootStraps {

	public static Bootstrap create(Connection connection) {

		Obstract obstract = connection.connection(new Obstract());

		return new BootstrapDevice(
				createDataSourseByConfiguration(obstract), 
				obstract.isShowSql(), 
				obstract.isCache(),
				obstract.isLog());

	}

	private static JdbcTemplate createDataSourseByConfiguration(Obstract obstract) {

		JdbcTemplate template = new JdbcTemplate();
		DataSource dataSource;
		try {
			dataSource = DataSources.create(obstract);
			template.setDataSource(dataSource);
			return template;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

	}

}
