package online.sanen.cdm;

import java.util.Arrays;
import java.util.HashSet;

import online.sanen.cdm.basic.Condition;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.SqlConditionException;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.basic.Condition.Conditions;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.Handels;
import online.sanen.cdm.factory.PipelineFactory;

public class QueryUpdateDevice implements QueryUpdate {
	
	Structure structure;

	public QueryUpdateDevice(Structure structure) {
		this.structure = structure;
	}

	@Override
	public QueryUpdate setTableName(String tableName) {
		structure.setTableName(tableName);
		return this;
	}

	@Override
	public QueryUpdate setFields(String... fields) {
		structure.setFields(new HashSet<>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public QueryUpdate addCondition(String fieldName, Conditions conditions) {
		try {
			structure.addCondition(new Condition(fieldName, conditions));
		} catch (SqlConditionException e) {
			e.printStackTrace();
		}
		return this;
	}

	@Override
	public QueryUpdate addCondition(String fieldName, Conditions conditions, Object value) {
		structure.addCondition(new Condition(fieldName, conditions,value));
		return this;
	}
	
	@Override
	public QueryUpdate addCondition(Condition... conditions) {
		for(Condition condition : conditions) {
			structure.addCondition(condition);
		}
		
		return this;
	}

	@Override
	public QueryUpdate setExceptFields(String... fields) {
		structure.setFields(new HashSet<>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public int update() {
		return (int) Assembler.create(QueryType.update, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}
	
	
}
