package online.sanen.cdm;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.Condition;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Condition.Conditions;
import online.sanen.cdm.basic.Structure.SortSupport;
import online.sanen.cdm.basic.SqlConditionException;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.Handels;
import online.sanen.cdm.factory.PipelineFactory;

/**
 * 
 * @author 懒得出风头
 * Date: 2017/11/23
 * Time: 22:22
 */
public class QueryTBDevice implements QueryTB {
	
	Structure structure;

	public QueryTBDevice(Manager manager, String tableName) {
		structure = new Structure(manager);
		structure.setTableName(tableName);
	}

	@Override
	public QueryTB addEntry(Class<? extends BasicBean> entry) {
		structure.setEntry_class(entry);
		return this;
	}

	@Override
	public QueryTB addCondition(String fieldName, Conditions conditions) {
		try {
			structure.addCondition(new Condition(fieldName, conditions));
		} catch (SqlConditionException e) {
			e.printStackTrace();
		}
		return this;
	}

	@Override
	public QueryTB addCondition(String fieldName, Conditions conditions, Object value) {
		structure.addCondition(new Condition(fieldName, conditions,value));
		return this;
	}
	
	@Override
	public QueryTB addCondition(Condition... conditions) {
		for(Condition condition : conditions) {
			structure.addCondition(condition);
		}
		
		return this;
	}
	
	@Override
	public QueryTB sort(final Sorts sorts, final String... fields) {
		
		structure.setSortSupport(new SortSupport() {
			
			@Override
			public String toString() {
				
				StringBuilder sb = new StringBuilder(" order by ");
				
				for(String field : fields) {
					sb.append(field+",");
				}
				
				sb.setLength(sb.length()-1);
				sb.append(" "+sorts.getValue());
				
				System.out.println(sb.toString());
				return sb.toString();
			}
		});
		
		return this;
	}

	@Override
	public QueryTB setFields(String... fields) {
		structure.setFields(new HashSet<>(Arrays.asList(fields)));
		return this;
	}

	@Override
	public QueryTB setExceptFields(String... fields) {
		structure.setExceptes(new HashSet<>(Arrays.asList(fields)));
		return this;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T uniqueResult() {
		return (T) Assembler.create(QueryType.select, ResultType.Object, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> List<T> list() {
		return  (List<T>) Assembler.create(QueryType.select, ResultType.List, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@Override
	public int remove() {
		return  (int) Assembler.create(QueryType.remove, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> List<T> limit(int start, Integer count) {
		structure.setLimit(start,count);
		
		return  (List<T>) Assembler.create(QueryType.select, ResultType.List, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.paramerHandel());
				pipeline.addLast(Handels.limitHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}


}
