package online.sanen.cdm;

import online.sanen.cdm.basic.BasicBean;
import online.sanen.cdm.basic.QueryType;
import online.sanen.cdm.basic.ResultType;
import online.sanen.cdm.basic.Structure;
import online.sanen.cdm.component.Manager;
import online.sanen.cdm.component.Pipeline;
import online.sanen.cdm.component.PipelineDivice;
import online.sanen.cdm.factory.Handels;
import online.sanen.cdm.factory.PipelineFactory;

/**
 * <pre>
 * @author online.sanen
 * Date: 2017/11/23
 * Time： 9:39
 * </pre>
 */
public class QueryECDevice<T extends BasicBean> implements  QueryEC<T> {
	Structure structure;


	public QueryECDevice(Manager manager, Class<T> entryCls, Object primarykey) {
		structure = new Structure(manager);
		structure.setPrimaryValue(primarykey);
		structure.setEntry_class(entryCls);
	}

	@SuppressWarnings("unchecked")
	@Override
	public T find() {
		return (T) Assembler.create(QueryType.select, ResultType.Bean, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.commonFieldHandel());
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.primaryKeyHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
	}

	@Override
	public int remove() {
		
		return (int) Assembler.create(QueryType.remove, ResultType.Int, structure, new PipelineFactory() {
			@Override
			public Pipeline getPipeline() {
				Pipeline pipeline = new PipelineDivice();
				pipeline.addLast(Handels.sqlHandel());
				pipeline.addLast(Handels.primaryKeyHandel());
				pipeline.addLast(Handels.conditionHandel());
				pipeline.addLast(Handels.resultHandel());
				pipeline.addLast(Handels.debugHandel());
				return pipeline;
			}
		});
		
	}




}
