package online.sanen.cdm.api.basic;

import java.util.function.Supplier;

/**
 * 
 * @author lazyToShow<br>
 *         Date: 2019/01/24<br>
 *         Time: 15:33
 *
 */
public class SimpleConfiguration implements Configuration {

	String url;

	/**
	 * Set the JDBC connection url
	 * 
	 * - Enumerate the different database connections:
	 * 
	 *            <pre>
	 * 				<code>
	 *            jdbc:oracle:thin:@//127.0.0.1:1521/orcl
	 *            jdbc:mysql://127.0.0.1:3306/test?useSSL=false
	 *            jdbc:sqlite:tmp/data/test.sqlite
	 *            jdbc:sqlserver://127.0.0.1:1433;DatabaseName=test
	 *        		 </code>
	 *            </pre>
	 */
	public void setUrl(String url) {
		this.url = url;
	}

	@Override
	public String url() {
		return url;
	}

	String driver;

	public void setDriverOption(DriverOption driverOption) {
		this.driver = driverOption.getValue();
	}

	public void setDriverOption(String driver) {
		this.driver = driver;
	}

	@Override
	public String driver() {
		return driver;
	}

	String username = "";

	public void setUsername(String username) {
		this.username = username;
	}

	@Override
	public String username() {
		return username;
	}

	String passrowd = "";

	public void setPassword(String passrowd) {
		this.passrowd = passrowd;
	}

	@Override
	public String password() {
		return passrowd;
	}

	boolean isShowSql = true;

	Supplier<Boolean> isShowSqlSupplier;

	public void setShowSql(boolean isShowSql) {
		this.isShowSql = isShowSql;
	}

	public void bindShowSql(Supplier<Boolean> consumer) {
		this.isShowSqlSupplier = consumer;
	}

	@Override
	public boolean isShowSql() {
		return isShowSqlSupplier == null ? isShowSql : isShowSqlSupplier.get();
	}

	boolean format;

	public void setFormat(boolean format) {
		this.format = format;
	}

	@Override
	public boolean isFormat() {
		return format;
	}

	boolean isLog;

	public void setLog(boolean isLog) {
		this.isLog = isLog;
	}

	@Override
	public boolean isLog() {
		return isLog;
	}

	String validationQuery = "SELECT 1";

	public void setValidationQuery(String validationQuery) {
		this.validationQuery = validationQuery;
	}

	@Override
	public String validationQuery() {
		return validationQuery;
	}

	DataSouseType dataSouseType;

	public void setDataSouseType(DataSouseType dataSouseType) {
		this.dataSouseType = dataSouseType;
	}

	@Override
	public DataSouseType dataSouseType() {
		return dataSouseType == null ? Configuration.super.dataSouseType() : dataSouseType;
	}

	boolean isCache;

	public void setCache(boolean isCache) {
		this.isCache = isCache;
	}

	@Override
	public boolean isCache() {
		return isCache;
	}

}
