package online.sanen.cdm.api.basic;

import com.mhdt.degist.Properties;

/**
 * 
 * @author lazyToShow <br>
 *         Date: 2019/01/24 <br>
 *         Time: 15:40
 *
 */
public class FileConfiguration implements Configuration {

	Properties properties;

	public void setProperties(Properties properties) {
		this.properties = properties;
	}

	@Override
	public DataSouseType dataSouseType() {
		return DataSouseType.valueOf(properties.get("dataSouseType", "Dbcp"));
	}

	@Override
	public String driver() {
		return properties.get("driver");
	}

	@Override
	public String url() {
		return properties.get("url");
	}

	@Override
	public String username() {
		return properties.get("username", "");

	}

	@Override
	public String password() {
		return properties.get("password", "");

	}

	@Override
	public boolean isLog() {
		return properties.getBoolean("isLog", false);

	}

	@Override
	public boolean isFormat() {
		return properties.getBoolean("isFormat", true);
	}

	@Override
	public boolean isCache() {
		return properties.getBoolean("isCache", false);
	}

	@Override
	public boolean isShowSql() {
		return properties.getBoolean("isShowSql", true);
	}

	@Override
	public String validationQuery() {
		return properties.get("validationQuery", "SELECT 1");
	}

}
