package online.sanen.cdm.api.basic;

/**
 * Abstract configuration instance objects, in addition to the <strong> Driver,
 * Url, Username, Password</strong>, are initialized with the default values
 * 
 * @author LazyToShow <br>
 *         Date: 2018/1/29 <br>
 *         Time: 11:36
 *
 */
public interface Configuration {

	public enum DataSouseType {
		Dbcp, Druid,C3p0
	}

	public default DataSouseType dataSouseType() {
		return DataSouseType.Dbcp;
	}
	
	public default String driver() {
		return null;
	}


	public default String url() {
		return null;
	}

	public default String username() {
		return "";
	}

	public default String password() {
		return "";
	}

	public default boolean isLog() {
		return false;
	}

	public default boolean isFormat() {
		return true;
	}

	public default boolean isCache() {
		return false;
	}

	public default boolean isShowSql() {
		return true;
	}

	public default String validationQuery() {
		return "SELECT 1";
	}

}
