package online.sanen.cdm.api.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import com.mhdt.degist.Validate;
import com.mhdt.toolkit.Reflect;

import online.sanen.cdm.api.component.Manager;
import online.sanen.cdm.api.component.ManagerBridge;
import online.sanen.cdm.api.condition.Condition;
import online.sanen.cdm.api.condition.SimpleCondition;
import online.sanen.cdm.template.jpa.JPA.Primarykey;

/**
 * <pre>
 * The intermediate products of the construction process are stored on the entity object.	
 * &#64;author LazyToShow
 * Date: 2017/10/21 
 * Time: 23:19
 * </pre>
 */
public class ChannelContext extends ManagerBridge {

	public ChannelContext(Manager manager) {
		super(manager);
	}

	Class<?> cls;

	String tableName;

	String schema;

	StringBuilder sql = new StringBuilder();

	List<Condition> conditions;

	Set<String> fields;

	Set<String> exceptes;

	Object entity;

	Map<String, Object> entityMap;

	Class<?> entityClass;

	Map<Integer, Object> paramers = new TreeMap<>();

	public String getTableName() {

		if (!Validate.isNullOrEmpty(tableName))
			return tableName;

		Class<?> entryClass = getEntityClass();

		if (entryClass != null)
			tableName = Cdm.getTableName(entryClass);

		return tableName;
	}

	public void setTableName(String tableName) {

		if (tableName.contains(".")) {
			String[] arr = tableName.split("\\.");
			this.tableName = arr[1];
			setSchema(arr[0]);
		} else {
			this.tableName = tableName;

		}

	}

	public StringBuilder getSql() {
		return sql;
	}

	public void setSql(String sql) {
		this.sql.setLength(0);
		this.sql.append(sql);
	}

	public List<Condition> getConditions() {
		if (conditions == null)
			conditions = new ArrayList<>();
		return conditions;
	}

	public void setConditions(List<Condition> conditions) {
		this.conditions = conditions;
	}

	public Set<String> getFields() {
		return fields;
	}

	public void setFields(Set<String> fields) {
		this.fields = fields;
	}

	public Set<String> getExceptes() {
		return exceptes;
	}

	public void setExceptes(Set<String> exceptes) {
		this.exceptes = exceptes;
	}

	public Class<?> getEntityClass() {
		if (entityClass != null)
			return entityClass;

		if (entity != null)
			return entityClass = entity.getClass();

		if (entities != null && entities.size() > 0)
			return entities.stream().findFirst().get().getClass();

		return null;
	}

	public void setEntityClass(Class<?> entityClass) {
		this.entityClass = entityClass;
	}

	public void addParamer(int index, Object paramer) {

		paramers.put(index, paramer);
	}

	public Object getEntity() {

		if (entity == null && getEntityClass() != null) {

			try {
				Class<?> cls = getEntityClass();
				entity = Reflect.newInstance(cls.getName());
			} catch (InstantiationException | IllegalAccessException | ClassNotFoundException e) {
				e.printStackTrace();
			}

		}

		return entity;
	}

	public void setEntity(Object entry) {
		this.entity = entry;
	}

	public Map<Integer, Object> getParamers() {
		return paramers;
	}

	public void setParamers(Map<Integer, Object> paramers) {
		this.paramers = paramers;
	}

	ResultType resultType;

	public ResultType getResultType() {
		return resultType;
	}

	public void setResultType(ResultType resultType) {
		this.resultType = resultType;
	}

	QueryType queryType;

	public QueryType getQueryType() {
		return queryType;
	}

	public void setQueryType(QueryType queryType) {
		this.queryType = queryType;
	}

	Set<String> commonFilds;

	public Set<String> getCommonFields() {
		return commonFilds;
	}

	public void setCommonFields(Set<String> tableFields) {
		this.commonFilds = tableFields;
	}

	/**
	 * 
	 * If the type of value is an <b>Array</b> or {@link Collection}, it will be
	 * broken down and added one by one.<br>
	 * <br>
	 * 
	 * An <b>Array</b>/{@link Collection} is valid when using a function like
	 * <b>BETWEEN</b> because it requires multiple arguments, and then an
	 * <b>Array</b>/{@link Collection} class is required . to wrap it
	 * 
	 * @param value
	 */
	public void addParamer(Object value) {

		if (value != null && value.getClass().isArray()) {
			Object[] array = (Object[]) value;
			for (Object it : array)
				this.addParamer(it);
		} else if (value != null && value instanceof Collection) {
			@SuppressWarnings("unchecked")
			Collection<Object> cc = (Collection<Object>) value;
			cc.forEach(this::addParamer);
		} else {
			paramers.put(paramers.size() + 1, value);
		}

	}

	public void addParamer(SimpleCondition condition) {

		Object value = condition.getValue();

		if (value == null) {
			paramers.put(paramers.size() + 1, value);
			return;
		}

		if (value.getClass().isArray()) {
			Object[] array = (Object[]) value;
			for (Object it : array)
				this.addParamer(it);
		} else if (value instanceof Collection) {
			@SuppressWarnings("unchecked")
			Collection<Object> cc = (Collection<Object>) value;
			cc.forEach(this::addParamer);
		} else {
			paramers.put(paramers.size() + 1, value);
		}

	}

	public void addCondition(Condition condition) {
		if (conditions == null)
			conditions = new ArrayList<Condition>();

		conditions.add(condition);
	}

	Primarykey primaryKey;

	public Primarykey getPrimaryKey() {

		if (primaryKey != null)
			return primaryKey;

		// Get From Entry

		Class<?> cls = getEntityClass();

		if (cls != null)
			primaryKey = Cdm.getPrimaryKey(cls);

		return primaryKey;
	}

	public void setPrimaryKey(Primarykey primaryKey) {
		this.primaryKey = primaryKey;
	}

	Integer[] limit;

	public void setLimit(Integer[] args) {
		this.limit = args;
	}

	public Integer[] getLimit() {
		return limit;
	}

	Collection<?> entities;

	public void setEntities(Collection<?> entrys) {
		this.entities = entrys;
	}

	public Collection<?> getEntities() {
		return entities;
	}

	/**
	 * Whether the current version supports limit operations in the current database
	 * .
	 */
	boolean isSupportLimit;

	public boolean isSupportLimit(boolean flag) {
		return isSupportLimit = flag;
	}

	public boolean isSupportLimitAble() {
		return isSupportLimit;
	}

	/**
	 * The limit operation is set
	 */
	boolean hasLimit;

	public boolean hasLimitAble() {
		return hasLimit;
	}

	public void setHasLimitAble(boolean flag) {
		hasLimit = flag;
	}

	public Map<String, Object> getEntityMap() {
		return entityMap;
	}

	public void setEntityMap(Map<String, Object> entityMap) {
		this.entityMap = entityMap;
	}

	SortSupport sortSupport;

	private Collection<Map<String, Object>> entityMaps;

	public interface SortSupport {

		public String toString();

	}

	public SortSupport getSortSupport() {
		return sortSupport;
	}

	public void setSortSupport(SortSupport sortSupport) {
		this.sortSupport = sortSupport;
	}

	public void setEntityMaps(Collection<Map<String, Object>> maps) {
		this.entityMaps = maps;
	}

	public Collection<Map<String, Object>> getEntityMaps() {
		return entityMaps;
	}

	public Class<?> getCls() {
		return cls;
	}

	public void setCls(Class<?> cls) {
		this.cls = cls;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

}
