package online.sanen.cdm.api.basic;

import com.mhdt.degist.Validate;
import com.mhdt.toolkit.Assert;
import com.mhdt.toolkit.Reflect;

import online.sanen.cdm.template.jpa.JPA;
import online.sanen.cdm.template.jpa.JPA.Primarykey;
import online.sanen.cdm.template.jpa.Table;

/**
 * 
 * @author LazyToShow <br>
 *         Date: 2018/06/12 <br>
 *         Time: 09:17
 */
public class Cdm {

	public static String getTableName(Class<?> entryClass) {

		if (Reflect.hasAnnotation(entryClass, Table.class)) {

			String tableName = JPA.getTableName(entryClass);

			if (!Validate.isNullOrEmpty(tableName))
				return tableName;
		}

		return entryClass.getSimpleName();
	}

	/**
	 * Process library name/namespace (Oracle). Table name
	 * 
	 * @param tableName
	 * @param schema
	 * @param productType
	 * @return
	 */
	public static String modified(String tableName, String schema, ProductType productType) {

		String modifer = ProductType.applyTableModifier(productType);
		return schema == null ? String.format("%s%s%s", modifer, tableName, modifer)
				: String.format("%s%s%s.%s%s%s", modifer, schema, modifer, modifer, tableName, modifer);
	}

	public static Primarykey getPrimaryKey(Class<?> entityClass) {

		Assert.notNull(entityClass, "Entry class is null");

		return JPA.getId(entityClass);
	}
	
	
	public static String schema(Class<?> entityClass) {
		Assert.notNull(entityClass, "Entry class is null");

		return JPA.schema(entityClass);
	}

	public static String getSql(ChannelContext context) {

		String sql = context.getSql().toString();

		sql = sql.replace("?", "#{?}");

		for (Object obj : context.getParamers().values()) {
			sql = sql.replaceFirst("#\\{\\?\\}", processObj(obj));
		}

		return sql;
	}

	private static String processObj(Object obj) {
		if (Validate.isNullOrEmpty(obj))
			return "null";

		String str = obj.toString();
		if (str.length() > 100)
			str = "[TEXT TOO LONG]";
		return (obj instanceof Integer) ? str : "'" + str + "'";
	}

}
