package online.sanen.cdm.api;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import online.sanen.cdm.api.basic.ProductType;
import online.sanen.cdm.api.basic.ChannelContext;

/**
 * Pipeline processor
 * 
 * @author LazyToShow <br>
 *         Date: 2017/10/21 <br>
 *         Time: 23:19
 */
public interface Handel {

	/**
	 * 
	 * @param context
	 * @param message
	 * @return
	 */
	Object handel(ChannelContext context, Object message);

	default void initFetchSize(PreparedStatement ps, ProductType productType) throws SQLException {
		if (productType == ProductType.MYSQL) {
			ps.setFetchSize(Integer.MIN_VALUE);
		} else {
			ps.setFetchSize(3000);
		}
	}

}
