package online.sanen.cdm.condition;

import java.util.List;
import java.util.function.Consumer;

import online.sanen.cdm.condition.Condition.Conditions;

/**
 * 
 *
 * @author LazyToShow	<br>
 * Date:	Oct 26, 2018	<br>
 * Time:	10:24:15 AM
 */
public interface ConditionAble {
	
	/**
	 * Add the query condition, which does not <strong>require</strong> value,
	 * <br>eg:
	 * {@code name is not null} <blockquote>addCondition("name",
	 * Conditions.IS_NOT_NULL)</blockquote>
	 * 
	 * @param fieldName
	 * @param conditions
	 * @return
	 */
	Object addCondition(String fieldName, Conditions conditions);

	/**
	 * Add conditions for the table fields <blockquote>addCondition("name",
	 * Conditions.EQUALS,"zhangsan")</blockquote>
	 * 
	 * @param fieldName
	 * @param conditions
	 * @param value
	 * @return
	 */
	Object addCondition(String fieldName, Conditions conditions, Object value);

	
	/**
	 * 
	 * @param consumer
	 * @return
	 */
	Object addCondition(Consumer<List<Condition>> consumer);

}
