package online.sanen.cdm.condition;

import java.util.List;

import online.sanen.cdm.basic.CdmConditionException;

/**
 * Query conditions Instance , In the form of objects embedded in the query
 * method . <br>
 * <br>
 * <strong>fieldName - </strong>In the name of the field operation .<br>
 * <strong>value - </strong>The value Of the field .<br>
 * <strong>conditions - </strong>The relationship between the field and value
 * .<br>
 * <br>
 * For example :
 * 
 * <pre>
 * 	<code>
 * 	new Condition('name',Conditions.EQUALS,'zhangsan');
 * 	</code>
 * </pre>
 * 
 * 
 * @author LAZY TO SHOW Date: 2016/07/25 Time: 14:56
 */
public class Condition {

	private String fieldName;

	private Conditions condition;

	private Object value;

	private Associated associated = Associated.AND;

	public enum Associated {
		AND, OR;
	}

	public Condition() {

	}

	public Condition(String fieldName, Conditions conditions) throws CdmConditionException {
		this(fieldName, conditions, null);
	}

	/**
	 * if this condition is not need value ( for example select id from tableName
	 * where name is not null, like this field : 'name' , because it's not neet
	 * value for itself ) <br>
	 * or else use another constructor <br>
	 * -
	 * {@code Condition(String fieldName,Options option) throws sqlConditionException}.
	 * 
	 * @param fieldName
	 * @param conditions
	 * @throws CdmConditionException
	 */
	public Condition(String fieldName, Conditions conditions, Associated associated) throws CdmConditionException {

		if (!conditions.equals(Conditions.IS_EMPTY) && !conditions.equals(Conditions.IS_NOT_EMPTY)
				&& !conditions.equals(Conditions.IS_NULL) && !conditions.equals(Conditions.IS_NOT_NULL))
			throw new CdmConditionException("this option : '" + conditions
					+ "' must match value. \r\n you can try to use @Condition(String fieldName,Object value,Options option)");

		if (associated != null)
			this.associated = associated;
		this.fieldName = fieldName;
		this.condition = conditions;
	}

	public Condition(String fieldName, Conditions condition, Object value) {
		this(fieldName, condition, value, null);
	}

	/**
	 * if the field is need value With the corresponding
	 * @param fieldName
	 * @param condition
	 * @param value
	 * @param associated
	 */
	public Condition(String fieldName, Conditions condition, Object value, Associated associated) {
		if (associated != null)
			this.associated = associated;
		this.fieldName = fieldName;
		this.value = value;
		this.condition = condition;
	}

	/** Detailed interpretation of the corresponding field conditions */
	public enum Conditions {

		GT(">?"), LT("<?"), lT_EQUALS("<=?"), GT_EQUALS(">=?"), IN(" in (?)"),NOT_IN(" not in (?)"), EQUALS("=?"), NO_EQUALS("<>?"),
		CONTAINS(" like '%?%'"), NO_CONTAINS(" NOT LIKE '%?%'"), MATCH("  against (? in boolean mode) "),
		START_WITH(" like '?%'"), END_WITH(" like '%?'"), IS_NULL(" is null"), IS_NOT_NULL(" is not null"),
		IS_EMPTY("=''"), IS_NOT_EMPTY(" <>''"), BETWEEN(" between ? AND ?");

		public String annotation;

		private Conditions(String annotation) {
			this.annotation = annotation;
		}

	}

	public static String getRealSql(String sql, List<Object> params) {
		for (Object obj : params) {
			String value = obj.toString();
			if (!(obj instanceof Integer)) {
				value = "'" + value + "'";
			}
			sql = sql.replaceFirst("\\?", value);
		}

		return sql;
	}

	public Conditions getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = Conditions.valueOf(condition);
	}

	public void setCondition(Conditions condition) {
		this.condition = condition;
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}
	

	public Associated getAssociated() {
		return associated;
	}

	public void setAssociated(Associated associated) {
		this.associated = associated;
	}

	public static Condition builder(String fieldName, Conditions conditions, Object value) {
		return new Condition(fieldName, conditions, value);
	}

	public static Condition builder(String fieldName, Conditions conditions, Object value, Associated associated) {
		return new Condition(fieldName, conditions, value, associated);
	}

	public static Condition builder(String fieldName, Conditions conditions) {
		return new Condition(fieldName, conditions);
	}

	public static Condition builder(String fieldName, Conditions conditions, Associated associated) {
		return new Condition(fieldName, conditions, associated);
	}

	@Override
	public String toString() {
		return "Condition [fieldName=" + fieldName + ", condition=" + condition + ", value=" + value + ", associated="
				+ associated + "]";
	}

}
