package online.sanen.cdm.basic;

import java.io.Serializable;

/**
 * 
 * Entity class base interface,The interface has been {@link Serializable} for
 * caching<br>
 * <br>
 * 
 * The entity class that participates in the operation needs to implement the
 * interface.The procedure may call the interface to do some primary key
 * operations such as <strong>query</strong>, <strong>delete</strong>, and
 * <strong>modify</strong>.Subsequent caches may also use this interface as a
 * basis to identify which data needs to be updated<br>
 * <br>
 * 
 * Implement <br>
 * <br>
 * <code> String getPrimarykey()</code><br>
 * <br>
 * to return the primary key of the entity corresponding table, and if
 * <strong>null</strong> is returned, the primary key is assumed to be called
 * <strong>id</strong>
 * 
 * <pre>
 * @author LazyToshow
 * Date:2017-11-20
 * Time:PM 8:48:54
 * </pre>
 */
public interface BasicBean extends Serializable {
	
	/**
	 * Gets the primary key name
	 * 
	 * @return - The primary key, if it returns null, <strong>id</strong> to be the
	 *         primary key by default<br>
	 */
	String primarykey();

}
