package online.sanen.cdm;

import java.util.List;
import java.util.function.Consumer;

import com.mhdt.annotation.Table;

import online.sanen.cdm.condition.ConditionAble;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.condition.Condition.Conditions;

/**
 * <pre>
 * QueryEn's derivative interface for handling modification operations,
 * Used to add conditions to the modified operation
 * 
 * @author LazyToShow
 * Date: 2017/11/29
 * Time: 21:00
 * </pre>
 */
public interface QueryUP extends ConditionAble{

	/**
	 * Set the table name, which has the highest priority to override the bean name
	 * and {@link Table} annotation
	 * 
	 * @param tableName
	 * @return
	 */
	QueryUP setTableName(String tableName);

	/**
	 * Sets the fields that participate in the operation, with the highest priority
	 * to override the fields of the entity class
	 * 
	 * @param fields
	 * @return
	 */
	QueryUP setFields(String... fields);
	
	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions);

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions, Object value);

	@Override
	public QueryUP addCondition(Consumer<List<Condition>> consumer);

	/**
	 * All other fields are involved
	 * 
	 * @param fields
	 * @return
	 */
	QueryUP setExceptFields(String... fields);

	int update();

}
