package online.sanen.cdm;

import java.util.List;
import java.util.function.Consumer;

import com.mhdt.annotation.Table;

import online.sanen.cdm.condition.ConditionAble;
import online.sanen.cdm.condition.Condition;
import online.sanen.cdm.condition.Condition.Conditions;

/**
 * <pre>
 * Custom table operations
 * @author LazyToShow
 * Date: 2017/10/21 
 * Time: 23:19
 *  </pre>
 */
public interface QueryEN extends ConditionAble{

	/**
	 * Set the table name, which has the highest priority to override the bean name
	 * and {@link Table} annotation
	 * 
	 * @param tableName
	 * @return
	 */
	QueryEN setTableName(String tableName);

	/**
	 * Sets the fields that participate in the operation, with the highest priority
	 * to override the fields of the entity class
	 * 
	 * @param fields
	 * @return
	 */
	QueryEN setFields(String... fields);

	/**
	 * All other fields are involved
	 * 
	 * @param fields
	 * @return
	 */
	QueryEN setExceptFields(String... fields);
	

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions);

	@Override
	public QueryUP addCondition(String fieldName, Conditions conditions, Object value);

	
	@Override
	public QueryUP addCondition(Consumer<List<Condition>> consumer);

	int insert();

	int delete();

	int update();

	int create();

}
