/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.basic;

import java.util.HashSet;
import online.sanen.cdm.basic.CdmQueryException;
import online.sanen.cdm.template.JdbcTemplate;

public enum ProductType {
    MYSQL,
    SQLITE,
    MICROSOFT_SQL_SERVER,
    ORACLE;


    public static String applyTableModifier(ProductType productType) {
        if (productType == MYSQL) {
            return "`";
        }
        if (productType == SQLITE || productType == ORACLE) {
            return "\"";
        }
        return "";
    }

    public static String updateTableNameSQL(ProductType productType, String tableName, String newName) {
        String modifier = ProductType.applyTableModifier(productType);
        if (productType == MICROSOFT_SQL_SERVER) {
            return "EXEC sp_rename " + modifier + tableName + modifier + ", '" + newName + "';";
        }
        return "ALTER TABLE " + modifier + tableName + modifier + " RENAME TO " + newName;
    }

    /*
     * Unable to fully structure code
     */
    public static HashSet<String> getColumnsFromTableName(ProductType productType, JdbcTemplate template, String tableName) {
        rs = null;
        switch (1.$SwitchMap$online$sanen$cdm$basic$ProductType[productType.ordinal()]) {
            case 1: {
                try {
                    conn = template.getDataSource().getConnection();
                    var5_6 = null;
                    rs = template.queryForRowSet("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? AND TABLE_SCHEMA = ?;", new Object[]{tableName, conn.getCatalog()});
                    if (conn == null) break;
                    if (var5_6 == null) ** GOTO lbl17
                    try {
                        conn.close();
                    }
                    catch (Throwable var6_7) {
                        var5_6.addSuppressed(var6_7);
                    }
                    break;
lbl17:
                    // 1 sources

                    conn.close();
                    ** break;
                    catch (Throwable var6_8) {
                        try {
                            var5_6 = var6_8;
                            throw var6_8;
                        }
                        catch (Throwable var7_9) {
                            if (conn != null) {
                                if (var5_6 != null) {
                                    try {
                                        conn.close();
                                    }
                                    catch (Throwable var8_10) {
                                        var5_6.addSuppressed(var8_10);
                                    }
                                } else {
                                    conn.close();
                                }
                            }
                            throw var7_9;
lbl34:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception e) {
                    throw new CdmQueryException(e);
                }
            }
            case 2: {
                rs = template.queryForRowSet("PRAGMA table_info('" + tableName + "')", new Object[0]);
                break;
            }
            case 3: {
                rs = template.queryForRowSet("SELECT column_name FROM INFORMATION_SCHEMA.columns WHERE TABLE_NAME=? ", new Object[]{tableName});
                break;
            }
            case 4: {
                if (tableName.contains(".")) {
                    tableName = tableName.split("\\.")[1];
                }
                rs = template.queryForRowSet("SELECT t.COLUMN_NAME FROM ALL_TAB_COLUMNS t where t.TABLE_NAME=?", new Object[]{tableName});
                break;
            }
            default: {
                throw new RuntimeException("You may not support the current connection database:" + (Object)productType + " type, but you can use the createSQL interface to continue the operation.");
            }
        }
        columns = new HashSet<String>();
        while (rs.next()) {
            if (productType.equals((Object)ProductType.SQLITE)) {
                columns.add(rs.getString(2));
                continue;
            }
            columns.add(rs.getString(1));
        }
        return columns;
    }

    public static boolean processLimit(ProductType productType, StringBuilder sql, Integer[] limit) {
        if (productType == null || sql == null || limit == null || limit[0] == null) {
            return false;
        }
        switch (productType) {
            case MYSQL: {
                ProductType.proceessCommonLimit(sql, limit);
                return true;
            }
            case SQLITE: {
                ProductType.proceessCommonLimit(sql, limit);
                return true;
            }
            case MICROSOFT_SQL_SERVER: {
                ProductType.proceessSqlServerLimit(sql, limit);
                return true;
            }
            case ORACLE: {
                ProductType.proceessOracleLimit(sql, limit);
                return true;
            }
        }
        return false;
    }

    private static void proceessOracleLimit(StringBuilder sql, Integer[] limit) {
        String[] split = sql.toString().split("from");
        String preffix = "select * from (" + split[0] + ",rownum rn from " + split[1] + ") v where v.rn";
        if (limit.length == 1) {
            preffix = preffix + "<=" + limit[0];
        }
        if (limit.length == 2) {
            preffix = preffix + ">" + limit[0] + " and v.rn<=" + (limit[0] + limit[1]);
        }
        sql.setLength(0);
        sql.append(preffix);
    }

    private static void proceessCommonLimit(StringBuilder sql, Integer[] limit) {
        sql.append(" limit " + limit[0]);
        if (limit.length > 1 && limit[1] != null && limit[1] > 0) {
            sql.append("," + limit[1]);
        }
    }

    private static void proceessSqlServerLimit(StringBuilder sql, Integer[] limit) {
        sql.replace(0, 6, "select top " + limit[0]).toString();
    }
}

