/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.basic;

import com.mhdt.analyse.Validate;
import com.mhdt.annotation.Priority;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import online.sanen.cdm.basic.BasicBean;

@Priority
public class DataField
implements BasicBean {
    private static final long serialVersionUID = -1899889100937800114L;
    String name;
    Object value;
    String type;
    Class<?> cls;
    String comment;
    boolean isPrimary;
    boolean autogrowth;
    Integer pk;
    String column_key;

    public DataField() {
    }

    public DataField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Class<?> getCls() {
        if (this.cls == null && this.type != null) {
            if (this.type.toLowerCase().equals("text") || this.type.toLowerCase().contains("varchar") || this.type.toLowerCase().contains("clob")) {
                return String.class;
            }
            return Integer.class;
        }
        return this.cls;
    }

    public void setCls(Class<?> cls) {
        this.cls = cls;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private void setPk(Integer pk) {
        if (pk != null && pk == 1) {
            this.isPrimary = true;
        }
        this.pk = pk;
    }

    private void setColumn_key(String column_key) {
        if (!Validate.isNullOrEmpty((Object)column_key) && column_key.equals("PRI")) {
            this.isPrimary = true;
        }
        this.column_key = column_key;
    }

    @Override
    public String primarykey() {
        return null;
    }

    public boolean isAutogrowth() {
        return this.autogrowth;
    }

    public void setAutogrowth(boolean autogrowth) {
        this.autogrowth = autogrowth;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public String toString() {
        return "DataField [name=" + this.name + ", value=" + this.value + ", type=" + this.type + ", cls=" + this.cls + ", comment=" + this.comment + ", isPrimary=" + this.isPrimary + "]";
    }

    public static boolean isComputable(DataField dataField) {
        return !dataField.getType().equals("text");
    }

    public static boolean isUnComputable(DataField dataField) {
        return dataField.getType().equals("text");
    }

    public static List<String> toNames(List<DataField> dataFields) {
        ArrayList<String> result = new ArrayList<String>();
        for (DataField column : dataFields) {
            result.add(Validate.isNullOrEmpty((Object)column.getValue()) ? column.getName() : column.getValue().toString());
        }
        Collections.sort(result, Comparator.comparing(Object::toString));
        return result;
    }

    public static boolean isSameName(List<DataField> comparetors) {
        String name = comparetors.get(0).getName();
        if (Validate.isNullOrEmpty((Object)name)) {
            return false;
        }
        return comparetors.stream().allMatch(column -> column.getName().equals(name));
    }

    public static List<DataField> completionType(List<Map<String, Object>> table, List<DataField> headers) {
        block2: for (DataField dataField : headers) {
            boolean isInteger = true;
            for (Map<String, Object> map : table) {
                Object obj = map.get(dataField.getName());
                if (Validate.isNullOrEmpty((Object)obj)) continue;
                if (!Validate.isNum((Object)obj)) {
                    dataField.setType("text");
                    dataField.setCls(String.class);
                    continue block2;
                }
                if (!isInteger) continue;
                try {
                    Integer.parseInt(obj.toString());
                }
                catch (NumberFormatException e) {
                    isInteger = false;
                }
            }
            dataField.setType(isInteger ? "integer" : "double");
            dataField.setCls(isInteger ? Integer.class : Double.class);
        }
        return headers;
    }
}

