/*
 * Decompiled with CFR 0.152.
 */
package online.sanen.cdm.basic;

import java.util.List;
import online.sanen.cdm.basic.SqlConditionException;

public class Condition {
    private String fieldName;
    private Object value;
    private Conditions condition;

    public Condition(String fieldName, Conditions conditions) throws SqlConditionException {
        if (!(conditions.equals((Object)Conditions.IS_EMPTY) || conditions.equals((Object)Conditions.IS_NOT_EMPTY) || conditions.equals((Object)Conditions.IS_NULL) || conditions.equals((Object)Conditions.IS_NOT_NULL))) {
            throw new SqlConditionException("this option : '" + (Object)((Object)conditions) + "' must match value. \r\n you can try to use @Condition(String fieldName,Object value,Options option)");
        }
        this.fieldName = fieldName;
        this.condition = conditions;
    }

    public Condition(String fieldName, Conditions conditions, Object value) {
        this.fieldName = fieldName;
        this.value = value;
        this.condition = conditions;
    }

    public static String getRealSql(String sql, List<Object> params) {
        for (Object obj : params) {
            String value = obj.toString();
            if (!(obj instanceof Integer)) {
                value = "'" + value + "'";
            }
            sql = sql.replaceFirst("\\?", value);
        }
        return sql;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Conditions getOption() {
        return this.condition;
    }

    public void setOption(Conditions option) {
        this.condition = option;
    }

    public String toString() {
        return "Condition [fieldName=" + this.fieldName + ", value=" + this.value + ", option=" + (Object)((Object)this.condition) + "]";
    }

    public static enum Conditions {
        GT(">?"),
        LT("<?"),
        lT_EQUALS("<=?"),
        GT_EQUALS(">=?"),
        IN(" in (?)"),
        EQUALS("=?"),
        NO_EQUALS("<>?"),
        CONTAINS(" like '%?%'"),
        NO_CONTAINS(" NOT LIKE '%?%'"),
        MATCH("  against (? in boolean mode) "),
        START_WITH(" like '?%'"),
        END_WITH(" like '%?'"),
        IS_NULL(" is null"),
        IS_NOT_NULL(" is not null"),
        IS_EMPTY("=''"),
        IS_NOT_EMPTY(" <>''");

        public String annotation;

        private Conditions(String annotation) {
            this.annotation = annotation;
        }
    }
}

