package com.qingcha.verifier.example;

import com.qingcha.verifier.core.annotation.SelectionOptions;
import com.qingcha.verifier.core.annotation.VerifierConfig;
import com.qingcha.verifier.core.annotation.VerifyObject;
import com.qingcha.verifier.core.annotation.VerifySubject;
import com.qingcha.verifier.core.verifier.MultipleSelectVerifier;
import com.qingcha.verifier.core.verifier.SelectVerifier;
import com.qingcha.verifier.core.verifier.TextVerifier;

import java.util.List;

/**
 * @author qiqiang
 */
@VerifyObject({
        @VerifierConfig(verifier = TextVerifier.class, warningFormat = "%s必填"),
        @VerifierConfig(verifier = SelectVerifier.class, warningFormat = "%s选项不合法"),
        @VerifierConfig(verifier = MultipleSelectVerifier.class)
})
public class Student {
    @VerifySubject(subject = "姓名", verifyIndex = 0)
    private String name;
    @VerifySubject(subject = "年级", verifyIndex = 1)
    @SelectionOptions({"一年级", "二年级", "三年级"})
    private String grade;
    @VerifySubject(subject = "爱好", verifyIndex = 2)
    @SelectionOptions({"打篮球", "踢足球", "打游戏"})
    private List<String> hobbies;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGrade() {
        return grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public List<String> getHobbies() {
        return hobbies;
    }

    public void setHobbies(List<String> hobby) {
        this.hobbies = hobbies;
    }
}