/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.AbstractVerifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TextVerifier
extends AbstractVerifier {
    private String waringFormat;

    public TextVerifier() {
        super(new ArrayList<VerifyItem>());
    }

    protected TextVerifier(List<VerifyItem> textData) {
        super(textData);
    }

    @Override
    public Optional<VerifyResponse> test(VerifyItem verifyItem) {
        if (StringUtils.isBlank(this.waringFormat)) {
            this.waringFormat = "%s\u6821\u9a8c\u5931\u8d25";
        }
        String key = verifyItem.getKey();
        String subject = verifyItem.getSubject();
        Object value = verifyItem.getValue();
        VerifyResponse response = new VerifyResponse(key, subject, String.format(this.waringFormat, subject));
        Optional<VerifyResponse> verifyFail = Optional.of(response);
        if (value == null) {
            return verifyFail;
        }
        if (value instanceof String) {
            return StringUtils.isBlank((String)value) ? verifyFail : Optional.empty();
        }
        throw new VerifierException("TextVerifier\u53ea\u80fd\u6821\u9a8cjava.lang.String");
    }

    @Override
    public void setWaringFormat(String waringFormat) {
        this.waringFormat = waringFormat;
    }
}

