/*
 * Decompiled with CFR 0.152.
 */
package com.qingcha.verifier.core.verifier;

import com.qingcha.verifier.core.VerifierException;
import com.qingcha.verifier.core.VerifyItem;
import com.qingcha.verifier.core.VerifyResponse;
import com.qingcha.verifier.core.utils.StringUtils;
import com.qingcha.verifier.core.verifier.AbstractVerifier;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

public class TextRegexVerifier
extends AbstractVerifier {
    private String waringFormat;
    private String pattern;

    protected TextRegexVerifier(List<VerifyItem> dateData, String pattern) {
        super(dateData);
        this.pattern = pattern;
    }

    @Override
    public Optional<VerifyResponse> test(VerifyItem verifyItem) {
        String key = verifyItem.getKey();
        Object value = verifyItem.getValue();
        String subject = verifyItem.getSubject();
        if (StringUtils.isBlank(this.waringFormat)) {
            this.waringFormat = "%s\u6821\u9a8c\u5931\u8d25";
        }
        Optional<VerifyResponse> verifyFail = Optional.of(new VerifyResponse(key, subject, String.format(this.waringFormat, key)));
        if (value == null) {
            return verifyFail;
        }
        if (value instanceof String) {
            String contact = (String)value;
            if (StringUtils.isBlank(contact) || !Pattern.matches(this.pattern, contact)) {
                return verifyFail;
            }
            return Optional.empty();
        }
        throw new VerifierException(this.getClass().getSimpleName() + "\u53ea\u80fd\u6821\u9a8cString\u7c7b\u578b");
    }

    @Override
    public void setWaringFormat(String waringFormat) {
        this.waringFormat = waringFormat;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

